/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbRootElement21 extends XbRootElement {

    protected Element createRootElement(Connection conn, Document doc) throws XbException {

        // hLg[g쐬
        Element rootElement = super.createElement(doc, XbConstants.TAG_ROOT_21);
        // OԎ擾
        ArrayList<XbRootElementObj> objList = XbRootElementDAO.getInstance(conn).getRootAttr(XbConstants.SPECIFICATION_NO_21);
        // OԐݒ
        super.addNameSpace(objList, rootElement);

        // [gGgԂ
        return rootElement;
    }
}