/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbFootNoteDAO extends XbEtcDAO {

    // singleton쐬
    private static final XbFootNoteDAO instance = new XbFootNoteDAO();
    private Connection conn = null;

    // RXgN^
    private XbFootNoteDAO() {
    }

    // CX^X擾
    protected static synchronized XbFootNoteDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected ArrayList<XbEtcObj> getFootNote(long taxGroupId, long etcId, long pEtcId) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            strb_sql.append("select ");
            strb_sql.append("foot.etc_type as etc_type ");
            strb_sql.append(", foot.etc_id as etc_id ");
            strb_sql.append(", foot.parent_etc_id as parent_etc_id ");
            strb_sql.append(", etc.name as name ");
            strb_sql.append(", etc.value as value ");
            strb_sql.append("from ");
            strb_sql.append("xb_item_footnote foot ");
            strb_sql.append(", xb_etc etc ");
            strb_sql.append("where ");
            strb_sql.append("foot.main_id = ? ");
            strb_sql.append("and foot.etc_type = etc.etc_type ");
            strb_sql.append("and foot.etc_id = etc.etc_id ");
            strb_sql.append("and foot.etc_id = ? ");
            strb_sql.append("and foot.parent_etc_id = ?");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setLong(index++, taxGroupId);
            stmt.setLong(index++, etcId);
            stmt.setLong(index++, pEtcId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEtcObj> relist = new ArrayList<XbEtcObj>();
            while (rs.next()) {
                XbEtcObj obj = new XbEtcObj();
                obj.setEtcId(rs.getLong("etc_id"));
                obj.setParentEtcId(rs.getLong("parent_etc_id"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setAttrList(super.getEtcAttributes(conn, rs.getInt("etc_type"), rs.getLong("etc_id")));
                relist.add(obj);
            }

            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected ArrayList<XbEtcObj> getEtc(long etcId, long pEtcId) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            strb_sql.append("select ");
            strb_sql.append("foot.etc_type as etc_type ");
            strb_sql.append(", foot.etc_id as etc_id ");
            strb_sql.append(", foot.parent_etc_id as parent_etc_id ");
            strb_sql.append(", etc.name as name ");
            strb_sql.append(", etc.value as value ");
            strb_sql.append("from ");
            strb_sql.append("xb_item_footnote foot ");
            strb_sql.append(", xb_etc etc ");
            strb_sql.append("where ");
            strb_sql.append("foot.main_id = ? ");
            strb_sql.append("and foot.etc_type = etc.etc_type ");
            strb_sql.append("and foot.etc_id = etc.etc_id ");
            strb_sql.append("and foot.parent_etc_id = ?");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setLong(index++, etcId);
            stmt.setLong(index++, pEtcId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEtcObj> relist = new ArrayList<XbEtcObj>();
            while (rs.next()) {
                XbEtcObj obj = new XbEtcObj();
                obj.setEtcId(rs.getLong("etc_id"));
                obj.setParentEtcId(rs.getLong("parent_etc_id"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setAttrList(super.getEtcAttributes(conn, rs.getInt("etc_type"), rs.getLong("etc_id")));
                relist.add(obj);
            }

            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}