/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
abstract class XbEtcDAO {

    protected ArrayList<XbEtcAttrObj> getEtcAttributes(Connection conn, int etcType, long etcId) throws XbException {
        final String query = "select etc_type , etc_id , name , value from xb_etc_attributes where etc_type = ? and etc_id = ? ";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);
            int index = 1;

            stmt.setInt(index++, etcType);
            stmt.setLong(index++, etcId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEtcAttrObj> relist = new ArrayList<XbEtcAttrObj>();
            while (rs.next()) {
                // TuXg
                XbEtcAttrObj obj = new XbEtcAttrObj();
                obj.setEtcAttrType(rs.getInt("etc_type"));
                obj.setEtcAttrId(rs.getLong("etc_id"));
                obj.setEtcAttrName(rs.getString("name"));
                obj.setEtcAttrValue(rs.getString("value"));

                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    abstract protected ArrayList<XbEtcObj> getEtc(long id, long pId) throws XbException;

    protected ArrayList<XbEtcObj> getFootNote(long taxGroupId, long etcId, long pEtcId) throws XbException {
        return null;
    }
}