/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbContext21 extends XbContext {

    private Document doc;
    private XbEntity entity;
    private XbPeriod period;
    private XbScenario scenario;
    private String contextId;

    protected XbContext21(Connection conn, Document doc) throws XbException {
        this.doc = doc;

        entity = new XbEntity(conn, doc);
        period = new XbPeriod(doc);
        scenario = new XbScenario(conn, doc);
        contextId = "";
    }

    protected Element createContext(XbContextObj obj, Element rootElement) throws XbException {
        Element context = null;

        if ("".equals(contextId) || !contextId.equals(obj.getName())) {
            // context^O쐬
            context = super.createElement(this.doc, XbConstants.TAG_CONTEXT);
            // idǉ
            super.setAttribute(context, XbConstants.ATTRIBUTE_ID, obj.getName());

            // entity^O쐬
            Element entityTag = entity.createEntity(obj.getEntityId(), rootElement);
            // period^O쐬
            Element periodTag = period.createPeriod(obj.getPeriodStartDate(), obj.getPeriodEndDate());
            // scenario^O쐬
            Element scenarioTag = scenario.createScenario(obj.getContextId(), rootElement);

            // context^Oɒǉ
            super.appendChild(context, entityTag); // entity
            super.appendChild(context, periodTag); // period
            super.appendChild(context, scenarioTag); // scenario

            contextId = obj.getName();
        }

        return context;
    }
}