/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * o[W2.1̃^N\m~[caɊi[NX
 * 
 * @author Going Dot Com Inc.
 */
public class XbTaxonomy21 extends XbTaxonomyImpl {

    /**
     * RXgN^
     * 
     * @param conn
     *            DBRlNV
     * @throws XbException
     */
    public XbTaxonomy21(Connection conn, String spec) throws XbException {
        super(conn, spec);
    }

    /**
     * Nx[Xo^p[^ݒ肷
     * 
     * @param linkObj
     *            Nx[Xp[^
     * @param linkobj
     *            XL[}link
     */
    protected void setLinkBaseFile(XbLinkBaseObj linkObj, URL pathName, XbLinkbaserefObj linkobj) throws XbException {
        try {
            String str = linkobj.getCategory().substring(0, linkobj.getCategory().indexOf(XbConstants.ROLE_URL_LINKBASEREF));

            if (XbConstants.ROLE_URL_CALCULATION.equals(str)) {
                // Calculation
                linkObj.setCalculationFileName(pathName.toURI().resolve(linkobj.getLinkbaseHref()).toString());
                // linkObj.setCalculationFileName(pathName + "/" + linkobj.getLinkbaseHref());
            } else if (XbConstants.ROLE_URL_DEFINITION.equals(str)) {
                // Definition
                linkObj.setDefinitionFileName(pathName.toURI().resolve(linkobj.getLinkbaseHref()).toString());
                // linkObj.setDefinitionFileName(pathName + "/" + linkobj.getLinkbaseHref());
            } else if (XbConstants.ROLE_URL_LABEL.equals(str)) {
                // Label
                linkObj.setLabelFileName(pathName.toURI().resolve(linkobj.getLinkbaseHref()).toString());
                // linkObj.setLabelFileName(pathName + "/" + linkobj.getLinkbaseHref());
            } else if (XbConstants.ROLE_URL_PRESENTATION.equals(str)) {
                // Presentation
                linkObj.setPresentationFileName(pathName.toURI().resolve(linkobj.getLinkbaseHref()).toString());
                // linkObj.setPresentationFileName(pathName + "/" + linkobj.getLinkbaseHref());
            } else if (XbConstants.ROLE_URL_REFERENCE.equals(str)) {
                // Reference
                linkObj.setReferenceFileName(pathName.toURI().resolve(linkobj.getLinkbaseHref()).toString());
                // linkObj.setReferenceFileName(pathName + "/" + linkobj.getLinkbaseHref());
            }
        } catch (IndexOutOfBoundsException e) {
            throw new XbException("ǂݍ񂾃^N\m~̃o[WႢ܂B");
        } catch (URISyntaxException e) {
            throw new XbException(e);
        }
    }

    /**
     * importĂXL[}擾
     * 
     * @param importList
     *            import^OXg
     * @return importt@CXg
     */
    protected ArrayList<URL> getImportList(NodeList importList) {
        ArrayList<URL> list = new ArrayList<URL>();

        // Xg񐔃[v
        for (int i = 0; i < importList.getLength(); i++) {
            // vf擾
            Node child = importList.item(i);
            // 擾
            NamedNodeMap attrs = child.getAttributes();

            String strValue = attrs.getNamedItem(XbConstants.TAG_IMPORT_SCHEMALOCATION).getNodeValue();

            if (super.isAddFlg(strValue, XbConstants.SPECIFICATION_NO_21)) {
                try {
                    super.schemaList.add(strValue);
                    // Xgɒǉ
                    list.add(new URL(strValue));
                } catch (MalformedURLException e) {
                    // TODO
                }
            }
        }

        return list;
    }
}