/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbLinkbaseResourceDAO {

    // singleton쐬
    private static XbLinkbaseResourceDAO singleton = null;
    // Connectionϐ
    private static Connection conn = null;

    // RXgN^
    private XbLinkbaseResourceDAO() {
    }

    // CX^X擾
    public static XbLinkbaseResourceDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (singleton == null) {
            conn = connection;
            singleton = new XbLinkbaseResourceDAO();
        }

        return singleton;
    }

    protected int insert(XbLinkbaseResourceObj obj) throws XbException {
        final String query = "insert into xb_linkbase_resource values (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;

        try {
            // SQLݒ
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setLong(index++, obj.getResource_id());
            stmt.setLong(index++, obj.getLinkbaseref_id());
            stmt.setString(index++, obj.getResource_label());
            stmt.setString(index++, obj.getResource_title());
            stmt.setString(index++, obj.getLabel_role());
            stmt.setString(index++, obj.getLabel_lang());
            stmt.setString(index++, obj.getResource_value());

            // SQL@s
            int count = stmt.executeUpdate();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}