/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbItemOrderDAO {

    // singleton쐬
    private static XbItemOrderDAO instance = new XbItemOrderDAO();
    // Connectionϐ
    private Connection conn = null;
    // orderID
    private int orderId;

    // RXgN^
    private XbItemOrderDAO() {
    }

    // CX^X擾
    public static synchronized XbItemOrderDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    private void getItemChild(long grpId, long itemId, String lang) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("wk.taxonomy_group_id as taxonomy_group_id, ");
            strb_sql.append("wk.taxonomy_id as taxonomy_id, ");
            strb_sql.append("wk.taxonomy_item_id as taxonomy_item_id, ");
            strb_sql.append("wk.item_type as item_type, ");
            strb_sql.append("wk.parent_taxonomy_item_id as parent_taxonomy_item_id, ");
            strb_sql.append("wk.parent_item_type as parent_item_type, ");
            strb_sql.append("wk.context_type as context_type, ");
            strb_sql.append("wk.presentation_order as presentation_order, ");
            strb_sql.append("la.label_lang as item_lang, ");
            strb_sql.append("la.resource_value as item_name ");
            strb_sql.append("from ");
            strb_sql.append("xb_item_work wk, xb_item_label la ");
            strb_sql.append("where ");
            strb_sql.append("wk.taxonomy_group_id = ? ");
            strb_sql.append("and parent_taxonomy_item_id = ? ");
            strb_sql.append("and la.label_lang = ? ");
            strb_sql.append("and wk.taxonomy_item_id = la.taxonomy_item_id ");
            strb_sql.append("order by presentation_order");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setLong(index++, grpId);
            stmt.setLong(index++, itemId);
            stmt.setString(index++, lang);

            ResultSet rs = stmt.executeQuery();

            while (rs.next()) {
                // TuXg
                XbItemOrderObj obj = new XbItemOrderObj();
                obj.setItemOrder(orderId++);
                obj.setTaxonomyGroupId(rs.getLong("taxonomy_group_id"));
                obj.setTaxonomyId(rs.getLong("taxonomy_id"));
                obj.setTaxonomyItemId(rs.getLong("taxonomy_item_id"));
                obj.setItemType(rs.getString("item_type"));
                obj.setParentTaxonomyItemId(rs.getLong("parent_taxonomy_item_id"));
                obj.setParentItemType(rs.getString("parent_item_type"));
                obj.setContextType(rs.getString("context_type"));
                obj.setPresentationOrder(rs.getInt("presentation_order"));
                obj.setLang(rs.getString("item_lang"));
                obj.setValue(rs.getString("item_name"));

                // яo^
                this.insert(obj);
                // ċA
                this.getItemChild(obj.getTaxonomyGroupId(), obj.getTaxonomyItemId(), obj.getLang());
            }
            // ʃZbgN[Y
            rs.close();
            // Xe[ggN[Y
            stmt.close();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }

    private void insert(XbItemOrderObj obj) throws XbException {
        final String query = "insert into xb_item (item_order, taxonomy_group_id, taxonomy_id, taxonomy_item_id, item_type, parent_taxonomy_item_id, parent_item_type, context_type, presentation_order, item_lang, item_name) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, obj.getItemOrder());
            stmt.setLong(index++, obj.getTaxonomyGroupId());
            stmt.setLong(index++, obj.getTaxonomyId());
            stmt.setLong(index++, obj.getTaxonomyItemId());
            stmt.setString(index++, obj.getItemType());
            stmt.setLong(index++, obj.getParentTaxonomyItemId());
            stmt.setString(index++, obj.getParentItemType());
            stmt.setString(index++, obj.getContextType());
            stmt.setInt(index++, obj.getPresentationOrder());
            stmt.setString(index++, obj.getLang());
            stmt.setString(index++, obj.getValue());

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    // Xe[ggN[Y
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected void setItemOrder(ArrayList<XbItemTopObj> obj) throws XbException {
        // o^Ă錾ꖈɃACeׂ
        for (int i = 0; i < obj.size(); i++) {
            orderId = 1;
            this.getItemChild(obj.get(i).getTaxonomyGroupId(), obj.get(i).getTaxonomyItemId(), obj.get(i).getLang());
        }
    }
}