/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbEtcObj;

/**
 * @author Masako Okayasu
 */
public class XbEtcDao {

    // singleton쐬
    private static XbEtcDao instance = new XbEtcDao();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbEtcDao() {
    }

    // CX^X擾
    public static synchronized XbEtcDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbEtcObj obj) throws XbException {
        final String query = "insert into xb_etc values (?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, obj.getEtc_type());
            stmt.setLong(index++, obj.getEtc_id());
            stmt.setString(index++, obj.getEtc_name());
            stmt.setString(index++, obj.getName());
            stmt.setString(index++, obj.getValue());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbEtcObj> selectAll(int etc_type) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("etc_type, ");
            strb_sql.append("etc_id, ");
            strb_sql.append("etc_name, ");
            strb_sql.append("name, ");
            strb_sql.append("value, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_etc ");
            strb_sql.append("where etc_type=? ");
            strb_sql.append("order by etc_id ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setInt(index++, etc_type);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbEtcObj> relist = new ArrayList<XbEtcObj>();
            while (rs.next()) {
                XbEtcObj obj = new XbEtcObj();
                obj.setEtc_type(rs.getInt("etc_type"));
                obj.setEtc_id(rs.getLong("etc_id"));
                obj.setEtc_name(rs.getString("etc_name"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            // Xe[ggN[Y
            stmt.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbEtcObj select(int etc_type, long etc_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("etc_type, ");
            strb_sql.append("etc_id, ");
            strb_sql.append("etc_name, ");
            strb_sql.append("name, ");
            strb_sql.append("value, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_etc ");
            strb_sql.append("where etc_type=? and etc_id=? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setInt(index++, etc_type);
            stmt.setLong(index++, etc_id);

            ResultSet rs = stmt.executeQuery();
            XbEtcObj obj = null;
            while (rs.next()) {
                obj = new XbEtcObj();
                obj.setEtc_type(rs.getInt("etc_type"));
                obj.setEtc_id(rs.getLong("etc_id"));
                obj.setEtc_name(rs.getString("etc_name"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            // Xe[ggN[Y
            stmt.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public long getNextId(int etc_type) throws XbException {
        final String query = "select max(etc_id)+1 as max from xb_etc where etc_type = ?";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, etc_type);

            ResultSet rs = stmt.executeQuery();
            rs.next();

            return (rs.getLong("max") == 0 ? 1 : rs.getLong("max"));
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}