/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbEtcAttributesObj;

/**
 * @author Masako Okayasu
 */
public class XbEtcAttributesDao {

    // singleton쐬
    private static XbEtcAttributesDao instance = new XbEtcAttributesDao();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbEtcAttributesDao() {
    }

    public static synchronized XbEtcAttributesDao getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    public void insert(XbEtcAttributesObj obj) throws XbException {
        final String query = "insert into xb_etc_attributes values (?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, obj.getEtc_type());
            stmt.setLong(index++, obj.getEtc_id());
            stmt.setString(index++, obj.getName());
            stmt.setString(index++, obj.getValue());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public ArrayList<XbEtcAttributesObj> selectAll(int etc_type, long etc_id) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("etc_type, ");
            strb_sql.append("etc_id, ");
            strb_sql.append("name, ");
            strb_sql.append("value, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_etc_attributes ");
            strb_sql.append("where etc_type=? and etc_id=? ");
            strb_sql.append("order by name ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setInt(index++, etc_type);
            stmt.setLong(index++, etc_id);

            ResultSet rs = stmt.executeQuery();
            ArrayList<XbEtcAttributesObj> relist = new ArrayList<XbEtcAttributesObj>();
            while (rs.next()) {
                XbEtcAttributesObj obj = new XbEtcAttributesObj();
                obj.setEtc_type(rs.getInt("etc_type"));
                obj.setEtc_id(rs.getLong("etc_id"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setCreation_date(rs.getDate("creation_date"));
                relist.add(obj);
            }

            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    public XbEtcAttributesObj select(int etc_type, long etc_id, String name) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("etc_type, ");
            strb_sql.append("etc_id, ");
            strb_sql.append("name, ");
            strb_sql.append("value, ");
            strb_sql.append("creation_date ");
            strb_sql.append("from xb_etc_attributes ");
            strb_sql.append("where etc_type=? and etc_id=? and name=? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setInt(index++, etc_type);
            stmt.setLong(index++, etc_id);
            stmt.setString(index++, name);

            ResultSet rs = stmt.executeQuery();
            XbEtcAttributesObj obj = null;
            while (rs.next()) {
                obj = new XbEtcAttributesObj();
                obj.setEtc_type(rs.getInt("etc_type"));
                obj.setEtc_id(rs.getLong("etc_id"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setCreation_date(rs.getDate("creation_date"));
            }

            // ʃZbgN[Y
            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}