/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.XbRefAttributesDao;
import jp.co.going.xbrl.sample.dao.XbRefDao;
import jp.co.going.xbrl.sample.dao.obj.XbRefAttributesObj;
import jp.co.going.xbrl.sample.dao.obj.XbRefObj;

/**
 * @author Masako Okayasu
 */
@SuppressWarnings("serial")
public class XbRefInput extends XbTreeDataSet implements ActionListener {

    private Connection conn = null;
    private XbRefDao refDao = null;
    private XbRefAttributesDao refAttrDao = null;

    private XbMyTreeNode rootNode = new XbMyTreeNode("io^σXgj");
    private JButton expButton = new JButton("WJ");

    private int sampleCount = 1;
    private boolean childFlag = false;

    private int insertFlag = 0;
    private long refID = 0;

    /**
     * RXgN^
     */
    public XbRefInput(Connection conn) {
        this.conn = conn;

        setTitle("XBRL Toolkit : Input " + REF);
        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }

        refDao = XbRefDao.getInstance(conn);
        refAttrDao = XbRefAttributesDao.getInstance(conn);

        Container container = getContentPane();
        container.setLayout(new BorderLayout());

        JPanel HeaderPanel = HeaderPanel();
        JPanel MainPanel = MainPanel();
        JPanel SubmitPanel = SubmitPanel();

        submitButton.addActionListener(this);
        submitButton.setEnabled(false);
        closeButton.addActionListener(this);

        container.add(HeaderPanel, BorderLayout.NORTH);
        container.add(MainPanel, BorderLayout.CENTER);
        container.add(SubmitPanel, BorderLayout.SOUTH);

        popMenu();
        setMouseAdapter();

        pack();
    }

    /**
     * Header̐
     */
    private JPanel HeaderPanel() {
        JPanel HeaderPanel = new JPanel();
        HeaderPanel.setLayout(new BorderLayout());

        HeaderPanel.add(new JLabel("@y " + nameList.get(REF) + "o^ <" + REF + "> z@@"), BorderLayout.WEST);

        expButton.addActionListener(this);
        HeaderPanel.add(setPanel(expButton), BorderLayout.CENTER);

        return HeaderPanel;
    }

    /**
     * Ref͗̐
     */
    private JPanel MainPanel() {
        JPanel MainPanel = new JPanel();
        MainPanel.setLayout(new BorderLayout());

        try {
            // ZOg̎}m[h̐
            for (Map.Entry<String, Integer> ent : refType.entrySet()) {
                String key = ent.getKey();
                int val = ent.getValue();

                ArrayList<XbRefObj> tableData = refDao.selectAllByType(val);
                if (tableData.size() > 0) {
                    XbMyTreeNode titleNode = new XbMyTreeNode("<" + key + ">");
                    rootNode.add(titleNode);

                    for (int i = 0; i < tableData.size(); i++) {
                        XbRefObj refObj = tableData.get(i);

                        // Ref
                        XbMyTreeNode refNode = new XbMyTreeNode(refObj.getRef_name());
                        refNode.setType(key);
                        refNode.setID(refObj.getRef_id());
                        titleNode.add(refNode);

                        ArrayList<XbRefAttributesObj> list = refAttrDao.selectAll(refObj.getRef_type(), refObj.getRef_id());
                        for (int j = 0; j < list.size(); j++) {
                            XbRefAttributesObj refAttributesObj = list.get(j);

                            // Ref Attributes
                            String nodeTitle = "F " + refAttributesObj.getName() + "=\"" + refAttributesObj.getValue() + "\"";
                            XbMyTreeNode attrNode = new XbMyTreeNode(nodeTitle);
                            attrNode.setType(key);
                            attrNode.setID(refAttributesObj.getRef_id());
                            refNode.add(attrNode);
                        }
                    }
                }
            }

            treeModel = new DefaultTreeModel(rootNode);
            tree = new JTree(treeModel);
            tree.setToggleClickCount(1);
            tree.setSelectionRow(0);
            selectNode = rootNode;

            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().setView(tree);
            scroll.setPreferredSize(new Dimension(400, 300));
            MainPanel.add(scroll, BorderLayout.NORTH);

            JLabel tooltip = new JLabel(TOOLTIP1);
            tooltip.setFont(setFont(11));
            tooltip.setPreferredSize(new Dimension(400, 26));
            MainPanel.add(tooltip, BorderLayout.SOUTH);

            popMenu();
            setMouseAdapter();

        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return MainPanel;
    }

    /**
     * ENbNj[̐
     */
    private void popMenu() {
        popMenu = new JPopupMenu();

        if (menuFlag == 0) {
            popMenuItem[0] = new JMenuItem(SCHEMAREF + "ǉ");
            popMenuItem[0].addActionListener(this);
            popMenu.add(popMenuItem[0]);

            popMenuItem[1] = new JMenuItem(LINKBASEREF + "ǉ");
            popMenuItem[1].addActionListener(this);
            popMenu.add(popMenuItem[1]);

            popMenuItem[2] = new JMenuItem(ROLEREF + "ǉ");
            popMenuItem[2].addActionListener(this);
            popMenu.add(popMenuItem[2]);

            popMenuItem[3] = new JMenuItem(ARCROLEREF + "ǉ");
            popMenuItem[3].addActionListener(this);
            popMenu.add(popMenuItem[3]);
        }

        if (menuFlag == 1) {
            popMenuItem[4] = new JMenuItem("vf̒ǉ");
            popMenuItem[4].addActionListener(this);
            popMenu.add(popMenuItem[4]);
        }

        if (menuFlag == 2 || menuFlag == 5) {
            popMenuItem[5] = new JMenuItem("̎w");
            popMenuItem[5].addActionListener(this);
            popMenu.add(popMenuItem[5]);
        }

        if (menuFlag == 5 || menuFlag == 9) {
            popMenuItem[6] = new JMenuItem("OύX");
            popMenuItem[6].addActionListener(this);
            popMenu.add(popMenuItem[6]);
        }

        if (menuFlag != 0) {
            popMenuItem[7] = new JMenuItem("폜");
            popMenuItem[7].addActionListener(this);
            popMenu.add(popMenuItem[7]);
        }
    }

    /**
     * MouseAdapter̓o^
     */
    private void setMouseAdapter() {
        tree.addMouseListener(new MouseAdapter() {
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int selectRow = tree.getRowForLocation(e.getX(), e.getY());

                    if (selectRow != -1) {
                        tree.setSelectionRow(selectRow);
                        selectNode = (XbMyTreeNode) tree.getLastSelectedPathComponent();
                        selectNodeName = selectNode.getUserObject().toString();

                        if (selectNode == rootNode) {
                            menuFlag = 0;
                        } else if (selectNodeName.indexOf(" sample") != -1) {
                            menuFlag = 9;
                        } else if (selectNodeName.indexOf("<" + SCHEMAREF + ">") != -1) {
                            menuFlag = 1;
                        } else if (selectNodeName.indexOf("<" + LINKBASEREF + ">") != -1) {
                            menuFlag = 1;
                        } else if (selectNodeName.indexOf("<" + ROLEREF + ">") != -1) {
                            menuFlag = 1;
                        } else if (selectNodeName.indexOf("<" + ARCROLEREF + ">") != -1) {
                            menuFlag = 1;
                        } else if (selectNodeName.indexOf("F ") != -1) {
                            menuFlag = 2;
                            childFlag = true;
                        } else {
                            menuFlag = 5;
                        }
                        popMenu();
                        popMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    /**
     * Button, MenuItem ̃Cxg擾
     */
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();

        if (source == popMenuItem[0]) {
            addNode("<" + SCHEMAREF + ">");
        } else if (source == popMenuItem[1]) {
            addNode("<" + LINKBASEREF + ">");
        } else if (source == popMenuItem[2]) {
            addNode("<" + ROLEREF + ">");
        } else if (source == popMenuItem[3]) {
            addNode("<" + ARCROLEREF + ">");
        } else if (source == popMenuItem[4]) {
            XbMyTreeNode childNode = new XbMyTreeNode("( sample" + sampleCount + " )");
            childNode.setType(selectNodeName.replace("<", "").replace(">", ""));
            selectNode.add(childNode);
            sampleCount++;
        } else if (source == popMenuItem[5]) {
            if (setNodeAttributes()) {
                submitButton.setEnabled(true);
            }
        } else if (source == popMenuItem[6]) {
            setNewNodeName2();
        } else if (source == popMenuItem[7]) {
            if (delNode()) {
                submitButton.setEnabled(true);
            }
        } else if (source == submitButton) {
            try {
                getNodeValue(rootNode);
                conn.commit();

                JOptionPane.showMessageDialog(this, "f[^o^܂B");
                submitButton.setEnabled(false);

            } catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (source == closeButton) {
            this.setVisible(false);
        }

        childFlag = false;

        treeModel.reload();
        tree.expandPath(new TreePath(selectNode));
        tree.setSelectionPath(new TreePath(selectNode.getPath()));
        selectNode = (XbMyTreeNode) tree.getLastSelectedPathComponent();

        if (source == expButton) {
            for (int i = 0; i < tree.getRowCount(); i++) {
                tree.expandRow(i);
            }
        }
    }

    /**
     * O̓͗̐iʃo[Wj
     */
    private void setNewNodeName2() {
        Object newName = JOptionPane.showInputDialog(this, "VOF", "", JOptionPane.INFORMATION_MESSAGE, null, null, selectNodeName);
        if (newName != null && !newName.equals("")) {
            selectNode.setUserObject(newName.toString().trim());
        }
    }

    /**
     * ̓͗̐
     */
    private boolean setNodeAttributes() {
        String name = "", value = "";
        boolean rc = false;

        if (selectNodeName.indexOf("F ") != -1) {
            String temp = selectNodeName.substring(selectNodeName.indexOf("F ") + 2).replace("\"", "");
            name = temp.substring(0, temp.indexOf("="));
            value = temp.substring(temp.indexOf("=") + 1);
        }

        Object attrName = JOptionPane.showInputDialog(this, "̖̂͂ĉF", "", JOptionPane.INFORMATION_MESSAGE, null, null, name);
        if (attrName != null && !attrName.equals("")) {

            Object attrValue = JOptionPane.showInputDialog(this, "̒l͂ĉF", "", JOptionPane.INFORMATION_MESSAGE, null, null, value);
            if (attrValue != null && !attrValue.equals("")) {
                String val = "F " + attrName.toString().trim() + "=\"" + attrValue.toString().trim() + "\"";

                if (childFlag == true) {
                    selectNode.setUserObject(val);
                } else {
                    XbMyTreeNode fieldNode = new XbMyTreeNode(val);
                    fieldNode.setType(selectNode.getType());
                    selectNode.add(fieldNode);
                }
                rc = true;
            }
        }
        return rc;
    }

    /**
     * m[h̒l擾
     */
    private void getNodeValue(XbMyTreeNode Node) {
        try {
            for (int i = 0; i < Node.getChildCount(); i++) {
                XbMyTreeNode childNode = (XbMyTreeNode) Node.getChildAt(i);
                String childNodeName = childNode.getUserObject().toString();

                if (childNode.getID() == 0 && childNode.getType() != null) {

                    // tO؂ւ
                    if (insertFlag == 2 && childNodeName.indexOf("F ") == -1) {
                        insertFlag = 1;
                    }

                    // Ref Attributes
                    if (insertFlag == 2) {
                        String temp = childNodeName.substring(childNodeName.indexOf("F ") + 2).replace("\"", "");
                        String name = temp.substring(0, temp.indexOf("="));
                        String value = temp.substring(temp.indexOf("=") + 1);

                        // R[h̑݊mF
                        XbRefAttributesObj refAttrObj = refAttrDao.select(refType.get(childNode.getType()), refID, name);

                        if (refAttrObj == null) {
                            refAttrObj = new XbRefAttributesObj();
                            refAttrObj.setRef_type(refType.get(childNode.getType()));
                            refAttrObj.setRef_id(refID);
                            refAttrObj.setName(name);
                            refAttrObj.setValue(value);
                            refAttrObj.setCreation_date(new Date());
                            refAttrDao.insert(refAttrObj);
                        }
                    }

                    // Ref
                    if (insertFlag == 1) {
                        refID = refDao.getNextId(refType.get(childNode.getType()));

                        XbRefObj refObj = new XbRefObj();
                        refObj.setRef_type(refType.get(childNode.getType()));
                        refObj.setRef_id(refID);
                        refObj.setRef_name(childNodeName);
                        refObj.setCreation_date(new Date());
                        refDao.insert(refObj);
                        insertFlag = 2;
                    }
                }

                if (childNodeName.indexOf("<" + SCHEMAREF + ">") != -1 || childNodeName.indexOf("<" + LINKBASEREF + ">") != -1
                        || childNodeName.indexOf("<" + ROLEREF + ">") != -1 || childNodeName.indexOf("<" + ARCROLEREF + ">") != -1) {
                    insertFlag = 1;
                }

                // ɐ[
                if (childNode.getChildCount() > 0) {
                    getNodeValue(childNode);
                }
            }
        } catch (XbException err) {
            try {
                err.printStackTrace();
                conn.rollback();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}