/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Properties;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

/**
 * @author Masako Okayasu
 */
@SuppressWarnings("serial")
public class XbCommon extends JFrame {

    public JButton submitButton = new JButton("o@@@^");
    public JButton closeButton = new JButton("@@");
    public LinkedHashMap<String, String> nameList = new LinkedHashMap<String, String>();
    public LinkedHashMap<String, Integer> etcType = new LinkedHashMap<String, Integer>();
    public LinkedHashMap<String, Integer> refType = new LinkedHashMap<String, Integer>();
    public LinkedHashMap<String, Integer> divideType = new LinkedHashMap<String, Integer>();
    public LinkedHashMap<String, Integer> operatorType = new LinkedHashMap<String, Integer>();
    public JComboBox unitCombo = new JComboBox(new String[] { "ʉ݈ȊO", "ʉ" });

    static public String NUMERIC = "numeric";
    static public String NONNUMERIC = "nonnumeric";

    static public String TOOLTIP1 = "@tH_̉ENbNŁA̎\ȏj[̂ݕ\܂B";
    static public String TOOLTIP2 = "@ENbNŁAIꂽs̍폜ł܂B";

    static public String TAX_TUPLE = "tuple";
    static public String TAX_ITEM = "item";

    static public String CONTEXT = "Context";
    static public String ENTITY = "Entity";
    static public String IDENTIFIER = "identifier";
    static public String SEGMENT = "Segment";
    static public String SCENARIO = "Scenario";
    static public String FOOTNOTE = "Footnote";
    static public String UNIT = "Unit";
    static public String MEASURE = "measure";
    static public String DIVIDE = "divide";
    static public String MULTIPLY = "multiply";
    static public String NUMERATOR = "unitNumerator";
    static public String DENOMINATOR = "unitDenominator";
    static public String TAXONOMY = "Taxonomy";

    static public String SCHEMAREF = "SchemaRef";
    static public String LINKBASEREF = "LinkbaseRef";
    static public String ROLEREF = "RoleRef";
    static public String ARCROLEREF = "ArcroleRef";
    static public String REF = "Ref";

    private Properties prop;

    /**
     * RXgN^
     */
    public XbCommon() {
        nameList.put(CONTEXT, "ReLXg");
        nameList.put(ENTITY, "GeBeB");
        nameList.put(IDENTIFIER, "ʎq");
        nameList.put(SEGMENT, "ZOg");
        nameList.put(SCENARIO, "ViI");
        nameList.put(FOOTNOTE, "tbgm[g");
        nameList.put(MEASURE, "Pʏ");
        nameList.put(UNIT, "Pʏڍ");
        nameList.put(REF, "q ");

        etcType.put(SEGMENT, 1);
        etcType.put(SCENARIO, 2);
        etcType.put(FOOTNOTE, 3);

        refType.put(SCHEMAREF, 1);
        refType.put(LINKBASEREF, 2);
        refType.put(ROLEREF, 3);
        refType.put(ARCROLEREF, 4);

        divideType.put(NUMERATOR, 1);
        divideType.put(DENOMINATOR, 2);

        operatorType.put(DIVIDE, 1);
        operatorType.put(MULTIPLY, 2);
    }

    /**
     * Connection̐
     */
    public Connection getConnection() {
        Connection conn = null;

        try {
            prop = new Properties();
            prop.load(new FileInputStream("xbrl.properties"));

            // JDBC
            Class.forName(prop.getProperty("CLASSNAME"));
            String url = (prop.getProperty("URL"));
            String user = (prop.getProperty("USER"));
            String pass = (prop.getProperty("PASSWORD"));
            conn = DriverManager.getConnection(url, user, pass);

            conn.setAutoCommit(false);
        } catch (SQLException ex) {
            ex.printStackTrace();
        } catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return conn;
    }

    /**
     * TitleBorder p̂߂̋ʐݒB
     */
    public TitledBorder setBorder(String borderTitle) {
        return new TitledBorder(new LineBorder(Color.BLACK), borderTitle, TitledBorder.LEFT, TitledBorder.TOP);
    }

    /**
     * Button ̋ʐݒB
     */
    public JButton setButton(String buttonTitle, String toolTip) {
        JButton button = new JButton(buttonTitle);
        button.setPreferredSize(new Dimension(130, 34));
        button.setFont(setFont(12));
        button.setToolTipText(toolTip);
        return button;
    }

    /**
     * TextField̐
     */
    public JTextField setField(int fieldWidth) {
        JTextField field = new JTextField();
        field.setPreferredSize(new Dimension(fieldWidth, 20));
        return field;
    }

    /**
     * Panel̐
     */
    public JPanel setPanel(Component obj) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(obj, BorderLayout.WEST);
        return panel;
    }

    /**
     * FileChooser̐
     */
    public String setFileSelect(String dialogTitle, int mode) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(dialogTitle);
        fileChooser.setFileSelectionMode(mode);
        String filePath = null;

        if (fileChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
            File file = fileChooser.getSelectedFile();
            filePath = file.getPath();
        }
        return filePath;
    }

    /**
     * Font ̋ʐݒB
     */
    public Font setFont(int fontSize) {
        return new Font("MS UI Gothic", Font.PLAIN, fontSize);
    }

    /**
     * ̎̕擾
     */
    public int getStringWidth(String str) {
        FontMetrics fm = getFontMetrics(setFont(12));
        ;
        return fm.stringWidth(str) + 40;
    }

    /**
     * GridBagLayout p̂߂̋ʐݒB
     */
    public GridBagConstraints setGrid(int x, int y, GridBagConstraints gbc) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0d;
        gbc.weighty = 1.0d;
        gbc.fill = GridBagConstraints.BOTH;
        gbc.insets = new Insets(7, 7, 7, 7);
        return gbc;
    }

    /**
     * o^E{^̐
     */
    public JPanel SubmitPanel() {
        JPanel SubmitPanel = new JPanel();
        SubmitPanel.setLayout(new BorderLayout());

        submitButton.setPreferredSize(new Dimension(100, 22));
        closeButton.setPreferredSize(new Dimension(100, 22));

        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(10, 40));
        panel.add(submitButton, BorderLayout.WEST);
        panel.add(closeButton, BorderLayout.EAST);

        SubmitPanel.add(panel);

        return SubmitPanel;
    }
}