/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbSegmentDAO extends XbEtcDAO {

    // singleton쐬
    private static final XbSegmentDAO instance = new XbSegmentDAO();
    private Connection conn = null;

    // RXgN^
    private XbSegmentDAO() {
    }

    // CX^X擾
    protected static synchronized XbSegmentDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected ArrayList<XbEtcObj> getEtc(long entityId, long pEtcId) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("seg.etc_type as etc_type ");
            strb_sql.append(", seg.etc_id as etc_id ");
            strb_sql.append(", seg.parent_etc_id as parent_etc_id ");
            strb_sql.append(", seg.prefix as prefix ");
            strb_sql.append(", seg.uri as uri ");
            strb_sql.append(", etc.name as name ");
            strb_sql.append(", etc.value as value ");
            strb_sql.append("from ");
            strb_sql.append("xb_entity_segment seg ");
            strb_sql.append(", xb_etc etc ");
            strb_sql.append("where ");
            strb_sql.append("seg.main_id = ? ");
            strb_sql.append("and seg.etc_type = etc.etc_type ");
            strb_sql.append("and seg.etc_id = etc.etc_id ");
            strb_sql.append("and seg.parent_etc_id = ?");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setLong(index++, entityId);
            stmt.setLong(index++, pEtcId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEtcObj> relist = new ArrayList<XbEtcObj>();
            while (rs.next()) {
                // TuXg
                XbEtcObj obj = new XbEtcObj();
                obj.setEtcId(rs.getLong("etc_id"));
                obj.setParentEtcId(rs.getLong("parent_etc_id"));
                obj.setPrefix(rs.getString("prefix"));
                obj.setUri(rs.getString("uri"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setAttrList(super.getEtcAttributes(conn, rs.getInt("etc_type"), rs.getLong("etc_id")));

                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}