/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbRootElementDAO {

    // singleton쐬
    private static final XbRootElementDAO instance = new XbRootElementDAO();
    private Connection conn = null;

    // RXgN^
    private XbRootElementDAO() {
    }

    // CX^X擾
    public static synchronized XbRootElementDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected ArrayList<XbRootElementObj> getRootAttr(String versions) throws XbException {
        final String query = "select namespace , namespace_url from xb_base_schema where specification_no = ? ";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setString(1, versions);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbRootElementObj> relist = new ArrayList<XbRootElementObj>();
            while (rs.next()) {
                // TuXg
                XbRootElementObj obj = new XbRootElementObj();
                obj.setNamespace(rs.getString("namespace"));
                obj.setNamespaceUrl(rs.getString("namespace_url"));

                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}