/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbInterfaceDAO {

    // singleton쐬
    private static final XbInterfaceDAO instance = new XbInterfaceDAO();
    // Connectionϐ
    private Connection conn = null;

    // RXgN^
    private XbInterfaceDAO() {
    }

    // CX^X擾
    public static synchronized XbInterfaceDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected void delete() throws XbException {
        final String query = "delete from xb_interface";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            // SQLs
            stmt.execute();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected void insertItem(XbMappingObj obj, String contextName, String unitName) throws XbException {
        final String query = "insert into xb_interface values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, obj.getItemOrder());
            stmt.setLong(index++, obj.getTaxonomyItemId());
            stmt.setInt(index++, 1);
            stmt.setLong(index++, obj.getTaxonomyItemId());
            stmt.setInt(index++, 1);
            stmt.setString(index++, obj.getItemValue());
            stmt.setInt(index++, obj.getItemPrecision());
            stmt.setInt(index++, obj.getItemDecimal());
            stmt.setString(index++, obj.getContextType());
            stmt.setString(index++, contextName);
            stmt.setString(index++, unitName);
            stmt.setString(index++, obj.getValue());

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected void insertTuple(XbTupleDataObj obj, String contextName, String unitName) throws XbException {
        final String query = "insert into xb_interface values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);

            int index = 1;
            stmt.setInt(index++, obj.getItemOrder());
            stmt.setLong(index++, obj.getTaxonomyItemId());
            stmt.setInt(index++, obj.getTaxonomyItemSeq());
            stmt.setLong(index++, obj.getParentTaxonomyItemId());
            stmt.setLong(index++, obj.getParentTaxonomyItemSeq());
            stmt.setString(index++, obj.getItemValue());
            stmt.setInt(index++, obj.getItemPrecision());
            stmt.setInt(index++, obj.getItemDecimal());
            stmt.setString(index++, obj.getContextType());
            stmt.setString(index++, contextName);
            stmt.setString(index++, unitName);
            stmt.setString(index++, obj.getValue());

            // SQL@s
            stmt.executeUpdate();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected ArrayList<XbInterfaceObj> select() throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("iface.item_order as item_order ");
            strb_sql.append(", iface.taxonomy_item_id as taxonomy_item_id ");
            strb_sql.append(", iface.taxonomy_item_seq as taxonomy_item_seq ");
            strb_sql.append(", iface.parent_taxonomy_item_id as parent_taxonomy_item_id ");
            strb_sql.append(", iface.parent_taxonomy_item_seq as parent_taxonomy_item_seq ");
            strb_sql.append(", iface.item_value as item_value ");
            strb_sql.append(", iface.item_precision as item_precision ");
            strb_sql.append(", iface.item_decimal as item_decimal ");
            strb_sql.append(", iface.context_type as context_type ");
            strb_sql.append(", iface.context_name as context_name ");
            strb_sql.append(", iface.unit_name as unit_name ");
            strb_sql.append(", iface.footnote_value as footnote_value ");
            strb_sql.append(", tax.namespace as namespace ");
            strb_sql.append(", tax.namespace_url as namespace_url ");
            strb_sql.append(", item.item_name as item_name ");
            strb_sql.append("from ");
            strb_sql.append("xb_interface iface, xb_taxonomy tax, xb_taxonomy_item item ");
            strb_sql.append("where ");
            strb_sql.append("item.taxonomy_item_id = iface.taxonomy_item_id ");
            strb_sql.append("and tax.taxonomy_id = item.taxonomy_id ");
            strb_sql.append("and iface.taxonomy_item_id = iface.parent_taxonomy_item_id ");
            strb_sql.append("and iface.taxonomy_item_seq = iface.parent_taxonomy_item_seq ");
            strb_sql.append("order by iface.item_order, iface.taxonomy_item_seq, iface.context_name");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbInterfaceObj> relist = new ArrayList<XbInterfaceObj>();
            while (rs.next()) {
                // TuXg
                XbInterfaceObj obj = new XbInterfaceObj();
                obj.setItemOrder(rs.getInt("item_order"));
                obj.setTaxonomyItemId(rs.getLong("taxonomy_item_id"));
                obj.setTaxonomyItemSeq(rs.getInt("taxonomy_item_seq"));
                obj.setParentTaxonomyItemId(rs.getLong("parent_taxonomy_item_id"));
                obj.setParentTaxonomyItemSeq(rs.getInt("parent_taxonomy_item_seq"));
                obj.setItemValue(rs.getString("item_value"));
                obj.setItemPrecision(rs.getInt("item_precision"));
                obj.setItemDecimal(rs.getInt("item_decimal"));
                obj.setContextType(rs.getString("context_type"));
                obj.setContextName(rs.getString("context_name"));
                obj.setUnitName(rs.getString("unit_name"));
                obj.setFootnoteValue(rs.getString("footnote_value"));
                obj.setNamespace(rs.getString("namespace"));
                obj.setNamespaceUrl(rs.getString("namespace_url"));
                obj.setItemName(rs.getString("item_name"));
                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }

    protected ArrayList<XbInterfaceObj> select(long parentId, int parentSeq) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("select ");
            strb_sql.append("iface.item_order as item_order ");
            strb_sql.append(", iface.taxonomy_item_id as taxonomy_item_id ");
            strb_sql.append(", iface.taxonomy_item_seq as taxonomy_item_seq ");
            strb_sql.append(", iface.parent_taxonomy_item_id as parent_taxonomy_item_id ");
            strb_sql.append(", iface.parent_taxonomy_item_seq as parent_taxonomy_item_seq ");
            strb_sql.append(", iface.item_value as item_value ");
            strb_sql.append(", iface.item_precision as item_precision ");
            strb_sql.append(", iface.item_decimal as item_decimal ");
            strb_sql.append(", iface.context_type as context_type ");
            strb_sql.append(", iface.context_name as context_name ");
            strb_sql.append(", iface.unit_name as unit_name ");
            strb_sql.append(", iface.footnote_value as footnote_value ");
            strb_sql.append(", tax.namespace as namespace ");
            strb_sql.append(", tax.namespace_url as namespace_url ");
            strb_sql.append(", item.item_name as item_name ");
            strb_sql.append("from ");
            strb_sql.append("xb_interface iface, xb_taxonomy tax, xb_taxonomy_item item ");
            strb_sql.append("where ");
            strb_sql.append("item.taxonomy_item_id = iface.taxonomy_item_id ");
            strb_sql.append("and tax.taxonomy_id = item.taxonomy_id ");
            strb_sql.append("and iface.parent_taxonomy_item_id = ? ");
            strb_sql.append("and iface.parent_taxonomy_item_seq = ? ");
            strb_sql.append("and iface.taxonomy_item_id != iface.parent_taxonomy_item_id ");
            strb_sql.append("order by iface.item_order, iface.taxonomy_item_seq, iface.context_name");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setLong(index++, parentId);
            stmt.setInt(index++, parentSeq);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbInterfaceObj> relist = new ArrayList<XbInterfaceObj>();
            while (rs.next()) {
                // TuXg
                XbInterfaceObj obj = new XbInterfaceObj();
                obj.setItemOrder(rs.getInt("item_order"));
                obj.setTaxonomyItemId(rs.getLong("taxonomy_item_id"));
                obj.setTaxonomyItemSeq(rs.getInt("taxonomy_item_seq"));
                obj.setParentTaxonomyItemId(rs.getLong("parent_taxonomy_item_id"));
                obj.setParentTaxonomyItemSeq(rs.getInt("parent_taxonomy_item_seq"));
                obj.setItemValue(rs.getString("item_value"));
                obj.setItemPrecision(rs.getInt("item_precision"));
                obj.setItemDecimal(rs.getInt("item_decimal"));
                obj.setContextType(rs.getString("context_type"));
                obj.setContextName(rs.getString("context_name"));
                obj.setUnitName(rs.getString("unit_name"));
                obj.setFootnoteValue(rs.getString("footnote_value"));
                obj.setNamespace(rs.getString("namespace"));
                obj.setNamespaceUrl(rs.getString("namespace_url"));
                obj.setItemName(rs.getString("item_name"));
                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}