/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbInstanceRefAttrDAO {

    // singleton쐬
    private static final XbInstanceRefAttrDAO instance = new XbInstanceRefAttrDAO();
    private Connection conn = null;

    // RXgN^
    private XbInstanceRefAttrDAO() {
    }

    // CX^X擾
    public static synchronized XbInstanceRefAttrDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected ArrayList<XbInstanceRefAttrObj> getInstanceRefAttr(int refType, long refId) throws XbException {
        final String query = "select ref_type, ref_id, name, value from xb_ref_attributes where ref_type = ? and ref_id = ? ";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);
            int index = 1;

            stmt.setInt(index++, refType);
            stmt.setLong(index++, refId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbInstanceRefAttrObj> relist = new ArrayList<XbInstanceRefAttrObj>();
            while (rs.next()) {
                XbInstanceRefAttrObj obj = new XbInstanceRefAttrObj();
                obj.setRefType(rs.getInt("ref_type"));
                obj.setRefId(rs.getLong("ref_id"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                relist.add(obj);
            }

            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}