/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbInstanceRef extends XbContext {

    private Document doc;

    private XbInstanceRefAttrDAO instanceRefAttrDAO;

    protected XbInstanceRef(Connection conn, Document doc) throws XbException {
        this.doc = doc;

        instanceRefAttrDAO = XbInstanceRefAttrDAO.getInstance(conn);
    }

    /**
     * InstanceRef쐬
     * 
     * @param entityId
     *            entityID
     * @return entityTag
     * @throws XbException
     */
    protected Element createInstanceRef(int refType, long refId) throws XbException {

        Element ref = null;
        // ref_typeō쐬Ggς
        if (refType == 1) { // schemaref
            ref = super.createElement(this.doc, XbConstants.TAG_SCHEMAREF);
        } else if (refType == 2) { // linkbaseref
            ref = super.createElement(this.doc, XbConstants.TAG_LINKBASEREF);
        } else if (refType == 3) { // roleref
            ref = super.createElement(this.doc, XbConstants.TAG_ROLEREF);
        } else if (refType == 4) { // arcroleref
            ref = super.createElement(this.doc, XbConstants.TAG_ARCROLEREF);
        }

        // refAttr擾
        ArrayList<XbInstanceRefAttrObj> refAttrList = instanceRefAttrDAO.getInstanceRefAttr(refType, refId);

        for (int i = 0; i < refAttrList.size(); i++) {
            XbInstanceRefAttrObj obj = refAttrList.get(i);
            // ǉ
            super.setAttribute(ref, XbConstants.NAMESPACE_XLINLK + obj.getName(), obj.getValue());
        }

        return ref;
    }
}