/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbFootNote extends XbContext {

    private Document doc;

    protected XbFootNote(Connection conn, Document doc) throws XbException {
        this.doc = doc;

        etcDAO = XbFootNoteDAO.getInstance(conn);
    }

    /**
     * FootNote쐬
     * 
     * @param footNoteId
     *            contextID
     * @return footnoteTag
     * @throws XbException
     */
    protected void createFootNote(long taxGroupId, long footNoteId, Element rootInstance) throws XbException {

        // footnote(root)擾
        ArrayList<XbEtcObj> footNoteList = etcDAO.getFootNote(taxGroupId, footNoteId, 0);

        for (int i = 0; i < footNoteList.size(); i++) {
            XbEtcObj obj = footNoteList.get(i);
            // ċA
            Element footNoteItem = super.createEtc(this.doc, taxGroupId, obj, XbConstants.TAG_LINK);
            // footNoteɐݒ
            super.appendChild(rootInstance, footNoteItem);
        }
    }
}