/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbTaxonomyGroupDAO {

    // singleton쐬
    private static XbTaxonomyGroupDAO taxGrp = null;
    // Connectionϐ
    private static Connection conn = null;

    // RXgN^
    private XbTaxonomyGroupDAO() {
    }

    // CX^X擾
    public static synchronized XbTaxonomyGroupDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (taxGrp == null) {
            conn = connection;
            taxGrp = new XbTaxonomyGroupDAO();
        }

        return taxGrp;
    }

    protected void insert(XbTaxonomyGroupObj obj)
        throws XbException {

        try {
            // Xe[gg쐬
            PreparedStatement stmt;

    		StringBuffer  strb_sql = new StringBuffer();
    	    // ⍇̎s
        	strb_sql.append("insert into ");
        	strb_sql.append("xb_taxonomy_group ");
        	strb_sql.append("values ");
        	strb_sql.append("(?, ?, ?, ?, ?)");

    		// SQLݒ
    		stmt = conn.prepareStatement(strb_sql.toString());

    		int index = 1;
    		stmt.setLong(index ++, obj.getTaxonomyGroupId());
    		stmt.setString(index ++, obj.getTaxonomyGroupName());
    		stmt.setString(index ++, obj.getSpecificationNo());
    		stmt.setString(index ++, obj.getNote());
            stmt.setTimestamp(index ++, new java.sql.Timestamp(obj.getCreationDate().getTime()));

            // SQL@s
    	   	stmt.executeUpdate();

    	    // Xe[ggN[Y
    	    stmt.close();

        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}
}