/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * o[W2.0̃^N\m~[caɊi[NX
 * 
 * @author Going Dot Com Inc.
 */
public class XbTaxonomy20 extends XbTaxonomyImpl {

    /**
	 * RXgN^
	 * @param 			conn DBRlNV
	 * @throws 		XbException
	 */
	public XbTaxonomy20(Connection conn, String spec) throws XbException {
	    super(conn, spec);
    }

    /**
     *  Nx[Xo^p[^ݒ肷
     * @param linkObj   Nx[Xp[^
     * @param linkobj   XL[}link
     */
    protected void setLinkBaseFile(XbLinkBaseObj linkObj, String pathName, XbLinkbaserefObj linkobj) {
        // Calculation
        if (XbConstants.ROLE_URL_CALCULATION.equals(linkobj.getCategory())) {
            linkObj.setCalculationFileName(pathName + "/" + linkobj.getLinkbaseHref());
        // Definition
        } else if (XbConstants.ROLE_URL_DEFINITION.equals(linkobj.getCategory())) {
            linkObj.setDefinitionFileName(pathName + "/" + linkobj.getLinkbaseHref());
        // Label
        } else if (XbConstants.ROLE_URL_LABEL.equals(linkobj.getCategory())) {
            linkObj.setLabelFileName(pathName + "/" + linkobj.getLinkbaseHref());
        // Presentation
        } else if (XbConstants.ROLE_URL_PRESENTATION.equals(linkobj.getCategory())) {
            linkObj.setPresentationFileName(pathName + "/" + linkobj.getLinkbaseHref());
        // Reference
        } else if (XbConstants.ROLE_URL_REFERENCE.equals(linkobj.getCategory())) {
            linkObj.setReferenceFileName(pathName + "/" + linkobj.getLinkbaseHref());
        }
    }

    /**
     * importĂXL[}擾
     * @param importList import^OXg
     * @return importt@CXg
     */
    protected ArrayList<String> getImportList(NodeList importList) {
        ArrayList<String> list = new ArrayList<String>();

        // Xg񐔃[v
        for (int i = 0;i < importList.getLength();i ++) {
            // vf擾
            Node child = importList.item(i);
            // 擾
            NamedNodeMap attrs = child.getAttributes();

            String strValue = attrs.getNamedItem(XbConstants.TAG_IMPORT_SCHEMALOCATION).getNodeValue();

            if (super.isAddFlg(strValue, XbConstants.SPECIFICATION_NO_20)) {
                super.schemaList.add(strValue);
                // Xgɒǉ
                list.add(strValue);
            }
        }

        return list;
    }
}