/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbResourceItemAttrDAO {

    // singleton쐬
    private static XbResourceItemAttrDAO singleton = null;
    // Connectionϐ
    private static Connection conn = null;
    // Xe[gg쐬
    private PreparedStatement stmt = null;

    // RXgN^
    private XbResourceItemAttrDAO() {
    }

    // CX^X擾
    public static XbResourceItemAttrDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (singleton == null) {
            conn = connection;
            singleton = new XbResourceItemAttrDAO();
        }

        return singleton;
    }

    protected int insert(XbResourceItemAttrObj obj)
        throws XbException {

        try {
            StringBuffer  strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("insert into ");
            strb_sql.append("xb_resource_item_attr ");
            strb_sql.append("values ");
            strb_sql.append("(?, ?, ?, ?)");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, obj.getResource_item_attr_id());
            stmt.setLong(index++, obj.getResource_item_id());
            stmt.setString(index++, obj.getAttribute_name());
            stmt.setString(index++, obj.getAttribute_value());

            // SQL@s
            int count =stmt.executeUpdate();

            // Xe[ggN[Y
            stmt.close();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}