/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbLinkbaseArcDAO {

    // singleton쐬
    private static XbLinkbaseArcDAO singleton = null;
    // Connectionϐ
    private static Connection conn = null;
    // Xe[gg쐬
    private PreparedStatement stmt = null;

    // RXgN^
    private XbLinkbaseArcDAO() {
    }

    // CX^X擾
    public static XbLinkbaseArcDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (singleton == null) {
            conn = connection;
            singleton = new XbLinkbaseArcDAO();
        }

        return singleton;
    }

    protected int insert(XbLinkbaseArcObj obj)
        throws XbException {

        try {
            StringBuffer  strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("insert into ");
            strb_sql.append("xb_linkbase_arc ");
            strb_sql.append("values ");
            strb_sql.append("(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, obj.getArc_id());
            stmt.setLong(index++, obj.getLinkbaseref_id());
            stmt.setString(index++, obj.getArc_show());
            stmt.setString(index++, obj.getArc_title());
            stmt.setString(index++, obj.getArc_from());
            stmt.setString(index++, obj.getArc_to());
            stmt.setString(index++, obj.getArc_arcrole());
            stmt.setString(index++, obj.getArc_use());
            stmt.setLong(index++, obj.getArc_priority());
            stmt.setDouble(index++, obj.getCalculation_weight());
            stmt.setDouble(index++, obj.getPresentation_order());

            // SQL@s
            int count =stmt.executeUpdate();

            // Xe[ggN[Y
            stmt.close();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}