/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbLinkRefNextIdDAO implements XbNextIdDAO {

    // singleton
    private static XbNextIdDAO nextId = null;
    // őli[ϐ
    private long nextValue = 0;

    // RXgN^
    private XbLinkRefNextIdDAO(Connection conn) throws XbException {

        try {
            // Xe[gg쐬
            PreparedStatement stmt;

            // TAXONOMY_GROUP_ID̍ől擾
            stmt = conn.prepareStatement("select max(linkbaseref_id) as id from xb_linkbaseref");

            ResultSet rs = stmt.executeQuery();
            while(rs.next()) {
                nextValue = rs.getLong("id");
            }

            // ʃZbgN[Y
            rs.close();

            // Xe[ggN[Y
            stmt.close();
        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
    }

    /**
     * CX^X𐶐
     * @param conn RlNV
     * @return LinkRefNextIdDAOCX^X
     * @throws XbException
     */
    public static synchronized XbNextIdDAO getInstance(Connection conn) throws XbException {
        // CX^X𐶐
        if (nextId == null) {
            nextId = new XbLinkRefNextIdDAO(conn);
        }

        return nextId;
    }

    /**
     * linkbaseref_id̃V[PXԍ擾
     * @return linkbaseref_id̍ől
     */
    public synchronized long getNextValue() {
        return ++ nextValue;
    }
}