/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.parse.XbPAOImpl;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author Going Dot Com Inc.
 */
public class XbLinkBase {

    // LinkBaseRef ID
    private long lLinkBaseRef_ID;

    // DAO
    XbLinkbaseRefDAO dbaLinkbaserefDAO;
    XbLinkbaseArcDAO dbaLinkbaseArcDAO;
    XbLinkbaseLocatorDAO dbaLinkbaseLocatorDAO;
    XbLinkbaseResourceDAO dbaLinkbaseResourceDAO;
    XbResourceItemDAO dbaResourceItemDAO;
    XbResourceItemAttrDAO dbaResourceItemAttrDAO;
    XbNextIdDAO arcIdDAO;
    XbNextIdDAO locIdDAO;
    XbNextIdDAO resourceIdDAO;
    XbNextIdDAO resourceItemIdDAO;
    XbNextIdDAO resourceItemAttrIdDAO;

    // RlNg
    Connection conn;

    Map<String, String> linkBaseMap;

    /**
     * RXgN^
     * @param           Connection DBRlNV
     * @throws      
     * @see             
     * @return      Ȃ
     */
    protected XbLinkBase(Connection conn) throws XbException {
        this.conn = conn;
        // Nx[XANZXNX
        dbaLinkbaserefDAO = XbLinkbaseRefDAO.getInstance(conn);
        // ArcANZXNX
        dbaLinkbaseArcDAO = XbLinkbaseArcDAO.getInstance(conn);
        // LocatorANZXNX
        dbaLinkbaseLocatorDAO = XbLinkbaseLocatorDAO.getInstance(conn);
        // ResourceANZXNX
        dbaLinkbaseResourceDAO = XbLinkbaseResourceDAO.getInstance(conn);
        // ResourceACeANZXNX
        dbaResourceItemDAO = XbResourceItemDAO.getInstance(conn);
        // ResourceACeANZXNX
        dbaResourceItemAttrDAO = XbResourceItemAttrDAO.getInstance(conn);

        // A[NID擾
        arcIdDAO = XbLinkArcNextIdDAO.getInstance(conn);
        // P[^ID擾
        locIdDAO = XbLinkLocNextIdDAO.getInstance(conn);
        // \[XID擾
        resourceIdDAO = XbLinkResourceNextIdDAO.getInstance(conn);
        // \[XACeID擾
        resourceItemIdDAO = XbLinkResourceItemNextIdDAO.getInstance(conn);
        // \[XACeID擾
        resourceItemAttrIdDAO = XbLinkResourceItemAttrNextIdDAO.getInstance(conn);
   }

    /**
     * Nx[Xݒ肷
     * @param           ArrayList   Nx[XIuWFNgXg
     * @throws          SQLException
     * @throws          ClassNotFoundException
     * @see             Ȃ
     * @return          Ȃ
     */
    protected void setLinkBase(XbLinkBaseObj obj) throws XbException {

        // --------------------------------------------
        // calculationt@Cǂݍ
        // --------------------------------------------
        if (obj.getCalculationFileName() != null) {
            // linkbaseRefe[uɎw肳ꂽ^N\m~[ID݂邩`FbN
            lLinkBaseRef_ID = dbaLinkbaserefDAO.select(
                                                obj.getTaxonomyId(),
                                                XbConstants.ROLE_URL_CALCULATION);

            this.readXmlFile(lLinkBaseRef_ID, obj.getCalculationFileName());
        }

        // --------------------------------------------
        // definitiont@Cǂݍ
        // --------------------------------------------
        if (obj.getDefinitionFileName() != null) {
            // linkbaseRefe[uɎw肳ꂽ^N\m~[ID݂邩`FbN
            lLinkBaseRef_ID = dbaLinkbaserefDAO.select(
                                                obj.getTaxonomyId(), 
                                                XbConstants.ROLE_URL_DEFINITION);

            this.readXmlFile(lLinkBaseRef_ID, obj.getDefinitionFileName());
        }

        // --------------------------------------------
        // presentationt@Cǂݍ
        // --------------------------------------------
        if (obj.getPresentationFileName() != null) {
            // linkbaseRefe[uɎw肳ꂽ^N\m~[ID݂邩`FbN
            lLinkBaseRef_ID = dbaLinkbaserefDAO.select(
                                                obj.getTaxonomyId(),
                                                XbConstants.ROLE_URL_PRESENTATION);

            this.readXmlFile(lLinkBaseRef_ID, obj.getPresentationFileName());
        }

        // --------------------------------------------
        // labelt@Cǂݍ
        // --------------------------------------------
        if (obj.getLabelFileName() != null) {
            // linkbaseRefe[uɎw肳ꂽ^N\m~[ID݂邩`FbN
            lLinkBaseRef_ID = dbaLinkbaserefDAO.select(
                                                obj.getTaxonomyId(),
                                                XbConstants.ROLE_URL_LABEL);

            this.readXmlFile(lLinkBaseRef_ID, obj.getLabelFileName());
        }

        // --------------------------------------------
        // referencet@Cǂݍ
        // --------------------------------------------
        if (obj.getReferenceFileName() != null) {
            // linkbaseRefe[uɎw肳ꂽ^N\m~[ID݂邩`FbN
            lLinkBaseRef_ID = dbaLinkbaserefDAO.select(
                                                obj.getTaxonomyId(),
                                                XbConstants.ROLE_URL_REFERENCE);

            this.readXmlFile(lLinkBaseRef_ID, obj.getReferenceFileName());
        }
    }

    /**
     * XMLt@Cǂݍ
     * @param           String          t@CpX
     * @throws          Ȃ
     * @see             Ȃ
     * @return          Ȃ
     */
    private void readXmlFile(long lLinkBaseRef_ID, String fileName) throws XbException {
        // lLinkBaseRef_ID0Ȃ珈Ȃ
        if (lLinkBaseRef_ID == 0) {
            return ;
        }
        // OԗpnbVe[u
        // Ώƃt@CʂɃCX^X𐶐
        linkBaseMap = new HashMap<String, String>();

        // p[T̐
        XbPAOImpl parser = new XbPAOImpl();
        // XMLt@C̃p[X
        parser.parse(fileName);
        // DOCUMENTm[h̎擾
        Document document = parser.getDocument();
        // DOM͏
        this.walk(document);
    }

    /**
     * m[hǂ
     * @param           Node          m[h
     * @throws          Ȃ
     * @see             Ȃ
     * @return          Ȃ
     */
    private void walk(Node node) throws XbException {
        // arci[ϐ
        XbLinkbaseArcObj arcObj;
        // locatori[ϐ
        XbLinkbaseLocatorObj locatorObj;
        // resourcei[ϐ
        XbLinkbaseResourceObj resourceObj;

        // node̎擾
        for(Node n = node.getFirstChild();n != null;n = n.getNextSibling()) {
            // element̔
            if (n.getNodeType() == Node.ELEMENT_NODE) {
                // l擾
                NamedNodeMap attrs = n.getAttributes();
                for (int i = 0;i < attrs.getLength();i ++) {
                    // OԂƖOURLێB
                    if ("linkbase".equals(n.getNodeName())) {
                        String strwk = null;
                        String sp[] = attrs.item(i).getNodeName().split(":");
                        if (sp.length >= 2) {
                            // O
                            strwk = sp[1];
                        }
                        // OԂnullłȂꍇAnbVe[uɓo^
                        if (strwk != null) {
                            linkBaseMap.put(strwk, attrs.item(i).getNodeValue());
                        }
                    }

                    // "xlink:type"̒l`FbN
                    if (XbConstants.ATTRIBUTE_XLINK_TYPE.equals(attrs.item(i).getNodeName())) {
                        // "arc"̏ꍇAArce[uݒ
                        if (XbConstants.ATTRIBUTE_ARC.equals(
                                attrs.getNamedItem(attrs.item(i).getNodeName()).getNodeValue())) {
                            arcObj = new XbLinkbaseArcObj();
                            // A[NID
                            arcObj.setArc_id(arcIdDAO.getNextValue());
                            // LinkBaseRef ID
                            arcObj.setLinkbaseref_id(lLinkBaseRef_ID);
                            for (int j = 0;j < attrs.getLength();j ++) {
                                // show
                                if (XbConstants.ATTRIBUTE_XLINK_SHOW.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setArc_show(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // title
                                if (XbConstants.ATTRIBUTE_XLINK_TITLE.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setArc_title(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // from
                                if (XbConstants.ATTRIBUTE_XLINK_FROM.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setArc_from(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // to
                                if (XbConstants.ATTRIBUTE_XLINK_TO.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setArc_to(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // arcrole
                                if (XbConstants.ATTRIBUTE_XLINK_ARCROLE.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setArc_arcrole(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // use
                                if (XbConstants.ATTRIBUTE_USE.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setArc_use(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // priority
                                if (XbConstants.ATTRIBUTE_PRIORITY.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setArc_priority(
                                            Long.parseLong(attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue()));
                                }
                                // weight
                                if (XbConstants.ATTRIBUTE_WEIGHT.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setCalculation_weight(
                                            Double.parseDouble(attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue()));
                                }
                                 // order
                                if (XbConstants.ATTRIBUTE_ORDER.equals(attrs.item(j).getNodeName())) {
                                    arcObj.setPresentation_order(
                                            Double.parseDouble(attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue()));
                                }
                            }
                            // Inserts
                            dbaLinkbaseArcDAO.insert(arcObj);
                        }

                        // "locator"̏ꍇALocatore[uݒ
                        if (XbConstants.ATTRIBUTE_LOCATOR.equals(
                                attrs.getNamedItem(attrs.item(i).getNodeName()).getNodeValue())) {
                            locatorObj = new XbLinkbaseLocatorObj();
                            // P[^ID
                            locatorObj.setLocator_id(locIdDAO.getNextValue());
                            // LinkBaseRef ID
                            locatorObj.setLinkbaseref_id(lLinkBaseRef_ID);
                            for (int j = 0;j < attrs.getLength();j ++) {
                                // href
                                if (XbConstants.ATTRIBUTE_XLINK_HREF.equals(attrs.item(j).getNodeName())) {
                                    String strHref = attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue();

                                    locatorObj.setLoc_href(strHref);
                                    // ʎqݒ肷
                                    locatorObj.setLoc_identifier(strHref.substring(strHref.lastIndexOf(XbConstants.SHARP_VALUE) + 1));
                                }
                                // label
                                if (XbConstants.ATTRIBUTE_XLINK_LABEL.equals(attrs.item(j).getNodeName())) {
                                    locatorObj.setLoc_label(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // title
                                if (XbConstants.ATTRIBUTE_XLINK_TITLE.equals(attrs.item(j).getNodeName())) {
                                    locatorObj.setLoc_title(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // role
                                if (XbConstants.ATTRIBUTE_XLINK_ROLE.equals(attrs.item(j).getNodeName())) {
                                    locatorObj.setLoc_role(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                            }
                            // Inserts
                            dbaLinkbaseLocatorDAO.insert(locatorObj);
                        }

                        // "resource"̏ꍇAResourcee[uݒ
                        if (XbConstants.ATTRIBUTE_RESOURCE.equals(
                                attrs.getNamedItem(attrs.item(i).getNodeName()).getNodeValue())) {
                            String strNodeVal = null;
                            resourceObj = new XbLinkbaseResourceObj();
                            // \[XID
                            resourceObj.setResource_id(resourceIdDAO.getNextValue());

                            // LinkBaseRef ID
                            resourceObj.setLinkbaseref_id(lLinkBaseRef_ID);
                            for (int j = 0;j < attrs.getLength();j ++) {
                                // label
                                if (XbConstants.ATTRIBUTE_XLINK_LABEL.equals(attrs.item(j).getNodeName())) {
                                    resourceObj.setResource_label(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // title
                                if (XbConstants.ATTRIBUTE_XLINK_TITLE.equals(attrs.item(j).getNodeName())) {
                                    resourceObj.setResource_title(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // role
                                if (XbConstants.ATTRIBUTE_XLINK_ROLE.equals(attrs.item(j).getNodeName())) {
                                    resourceObj.setLabel_role(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // lang
                                if (XbConstants.ATTRIBUTE_XML_LANG.equals(attrs.item(j).getNodeName())) {
                                    resourceObj.setLabel_lang(
                                            attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                                }
                                // l
                                strNodeVal = getNodeVal(n);

                                if (strNodeVal != null) {
                                    resourceObj.setResource_value(strNodeVal);
                                }
                            }
                            // Inserts
                            dbaLinkbaseResourceDAO.insert(resourceObj);
                            // lnull̏ꍇAqm[h
                            if (strNodeVal == null) {
                                // qm[hȂꍇA͍sȂ
                                this.setResourceItem(resourceObj,n);
                            }
                        }
                    }
                }
            }
            walk(n);
        }
    }

    /**
     * \[XACeo^
     * @param           XbLinkbaseResourceObj   LinkbaseResourceIuWFNg
     * @param           Node   m[h
     * @throws          Ȃ
     * @see             Ȃ
     * @return          Ȃ
     */
    private void setResourceItem(XbLinkbaseResourceObj resourceObj, Node node) throws XbException {
        XbResourceItemObj reitemObj;
        XbResourceItemAttrObj reitemAttrObj;
        ArrayList<XbResourceItemAttrObj> List;

        NodeList ls = node.getChildNodes();
        Node child = null;

        for(int i = 0;i < ls.getLength();i ++) {
            child = ls.item(i);
            if (child.getNodeType() == Node.ELEMENT_NODE) {
                reitemObj = new XbResourceItemObj();
                List = new ArrayList<XbResourceItemAttrObj>();
                String sp[] = child.getNodeName().split(":");

                reitemObj.setResource_item_id(resourceItemIdDAO.getNextValue());
                reitemObj.setResource_id(resourceObj.getResource_id());

                reitemObj.setNamespace(sp[0]);
                reitemObj.setNamespace_url((String)linkBaseMap.get(sp[0]));
                reitemObj.setItem_name(sp[1]);
                reitemObj.setItem_value(this.getNodeVal(child));

                if (linkBaseMap.get(sp[0]) == null) {
                    NamedNodeMap attrs = child.getAttributes();
                    for (int j = 0;j < attrs.getLength();j ++) {
                        reitemAttrObj = new XbResourceItemAttrObj();
                        reitemAttrObj.setResource_item_attr_id(resourceItemAttrIdDAO.getNextValue());
                        reitemAttrObj.setResource_item_id(reitemObj.getResource_item_id());
                        reitemAttrObj.setAttribute_name(attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeName());
                        reitemAttrObj.setAttribute_value(attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());

                        if (attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeName().indexOf("xmlns") != -1) {
                            reitemObj.setNamespace_url(attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue());
                        }
                        List.add(reitemAttrObj);
                    }
                }
                // \[XACee[uXV
                // Inserts
                dbaResourceItemDAO.insert(reitemObj);
                // \[XACee[uXV
                for (int k = 0;k < List.size();k ++) {
                    XbResourceItemAttrObj obj = List.get(k);
                    // Inserts
                    dbaResourceItemAttrDAO.insert(obj);
                }
            }
        }
        return ;
    }

    /**
     * w肵m[hValue擾
     * @param           Node        m[h
     * @throws      Ȃ
     * @see             Ȃ
     * @return      String      Valuel
     */
    private String getNodeVal(Node node) {
        if (node == null) {
            return null;
        }
        NodeList ls = node.getChildNodes();
        Node child = null;
        for(int i = 0; i<ls.getLength(); i++) {
            child = ls.item(i);
            if (child.getNodeType() == Node.TEXT_NODE) {
                return child.getNodeValue();
            }
        }
        return null;
    }
}