/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public abstract class XbItemLabelDAO {

    // Connectionϐ
    protected static Connection conn = null;

    private void insert(ArrayList<XbItemLabelObj> obj)  throws XbException {
        try {
            for (int i = 0;i < obj.size();i ++) {
                XbItemLabelObj label = obj.get(i);

                // Xe[gg쐬
                PreparedStatement stmt;

                StringBuffer  strb_sql = new StringBuffer();
                // ⍇̎s
                strb_sql.append("INSERT INTO ");
                strb_sql.append("xb_item_label (");
                strb_sql.append("taxonomy_group_id, ");
                strb_sql.append("taxonomy_id, ");
                strb_sql.append("taxonomy_item_id, ");
                strb_sql.append("label_lang, ");
                strb_sql.append("resource_value) ");
                strb_sql.append("VALUES ");
                strb_sql.append("(?, ?, ?, ?, ?)");

                // SQLݒ
                stmt = conn.prepareStatement(strb_sql.toString());

                int index = 1;
                stmt.setString(index++, label.getTaxGrpId());
                stmt.setString(index++, label.getTaxId());
                stmt.setString(index++, label.getItemId());
                stmt.setString(index++, label.getLang());
                stmt.setString(index++, label.getValue());

                // SQL@s
                stmt.executeUpdate();

                // Xe[ggN[Y
                stmt.close();
            }

        } catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
    }

    protected final void setItemLabel(long grpId) throws XbException {
        // \擾
        ArrayList<XbItemLabelObj> labelList = getItemLabel(grpId);
        // \o^
        this.insert(labelList);
    }

    abstract protected ArrayList<XbItemLabelObj> getItemLabel(long grpId) throws XbException;
}