/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbItemTopObj;

/**
 * @author Masako Okayasu
 */
public class XbItemTopDao {

	// singleton쐬
    private static XbItemTopDao itemTop = null;
    // Connectionϐ
    private static Connection conn = null;
	// Xe[gg쐬
    private PreparedStatement stmt;

    // RXgN^
    public XbItemTopDao(){
    }

    // CX^X擾
    public static synchronized XbItemTopDao getInstance(Connection connection){
    	//  CX^X𐶐
    	if(itemTop == null) {
    		conn = connection;
    		itemTop = new XbItemTopDao();
    	}

    	return itemTop;
    }

	public void insert(XbItemTopObj obj) throws XbException{

		try {
			StringBuffer strb_sql = new StringBuffer();
		    // ⍇̎s
	    	strb_sql.append("insert into ");
	    	strb_sql.append("xb_instance ");
	    	strb_sql.append("values ");
	    	strb_sql.append("(?,?,?,?)");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, obj.getTaxonomy_group_id());
			stmt.setLong(index++, obj.getTaxonomy_item_id());
			stmt.setString(index++, obj.getItem_lang());
			stmt.setString(index++, obj.getItem_name());

		   	// SQL@s
		   	stmt.executeUpdate();

		    // Xe[ggN[Y
		    stmt.close(); 

		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public ArrayList<XbItemTopObj> selectAll() throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("taxonomy_group_id, ");
			strb_sql.append("taxonomy_item_id, ");
			strb_sql.append("item_lang, ");
			strb_sql.append("item_name ");
			strb_sql.append("from xb_item_top ");
			strb_sql.append("order by taxonomy_group_id, taxonomy_item_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbItemTopObj> relist = new ArrayList<XbItemTopObj>();
			while(rs.next()) {
				XbItemTopObj obj = new XbItemTopObj();
				obj.setTaxonomy_group_id(rs.getLong("taxonomy_group_id"));
				obj.setTaxonomy_item_id(rs.getLong("taxonomy_item_id"));
				obj.setItem_lang(rs.getString("item_lang"));
				obj.setItem_name(rs.getString("item_name"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public XbItemTopObj select(long taxonomy_group_id, String item_lang) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("taxonomy_group_id, ");
			strb_sql.append("taxonomy_item_id, ");
			strb_sql.append("item_lang, ");
			strb_sql.append("item_name ");
			strb_sql.append("from xb_instance ");
			strb_sql.append("where taxonomy_group_id=? and item_lang=? ");
			strb_sql.append("order by taxonomy_item_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, taxonomy_group_id);
			stmt.setString(index++, item_lang);

			ResultSet rs = stmt.executeQuery();
			XbItemTopObj obj = null;
			while(rs.next()) {
				obj = new XbItemTopObj();
				obj.setTaxonomy_group_id(rs.getLong("taxonomy_group_id"));
				obj.setTaxonomy_item_id(rs.getLong("taxonomy_item_id"));
				obj.setItem_lang(rs.getString("item_lang"));
				obj.setItem_name(rs.getString("item_name"));
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return obj;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}
}