/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbMainEtcObj;

/**
 * @author Masako Okayasu
 */
public class XbItemFootnoteDao {

	// singleton쐬
    private static XbItemFootnoteDao itemFootnote = null;
    // Connectionϐ
    private static Connection conn = null;
	// Xe[gg쐬
    private PreparedStatement stmt;

    // e[u
	private String table1 = "xb_item_footnote";
	private String table2 = "xb_etc";

    // RXgN^
    public XbItemFootnoteDao(){
    }

    // CX^X擾
    public static synchronized XbItemFootnoteDao getInstance(Connection connection){
    	//  CX^X𐶐
    	if(itemFootnote == null) {
    		conn = connection;
    		itemFootnote = new XbItemFootnoteDao();
    	}

    	return itemFootnote;
    }

	public void insert(XbMainEtcObj obj) throws XbException{

		try {
			StringBuffer strb_sql = new StringBuffer();
		    // ⍇̎s
	    	strb_sql.append("insert into ");
	    	strb_sql.append(table1 + " ");
	    	strb_sql.append("values ");
	    	strb_sql.append("(?,?,?,?,?,?)");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, obj.getMain_id());
			stmt.setInt(index++, obj.getEtc_type());
			stmt.setLong(index++, obj.getEtc_id());
			stmt.setLong(index++, obj.getParent_etc_id());
			stmt.setLong(index++, obj.getPresentation_order());
	        stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

		   	// SQL@s
		   	stmt.executeUpdate();

		    // Xe[ggN[Y
		    stmt.close(); 

		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public ArrayList<XbMainEtcObj> selectAll(
			long context_id,
			long parent_etc_id
		) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("main_id, ");
			strb_sql.append(table1 + ".etc_type, ");
			strb_sql.append(table1 + ".etc_id, ");
			strb_sql.append("parent_etc_id, ");
			strb_sql.append("etc_name, ");
			strb_sql.append("name, ");
			strb_sql.append("value, ");
			strb_sql.append("presentation_order, ");
			strb_sql.append(table1 + ".creation_date ");
			strb_sql.append("from " + table1 + ", " + table2 + " ");
			strb_sql.append("where main_id=? ");
			strb_sql.append("and parent_etc_id=? ");
			strb_sql.append("and " + table1 + ".etc_type=" + table2 + ".etc_type ");
			strb_sql.append("and " + table1 + ".etc_id=" + table2 + ".etc_id ");
			strb_sql.append("order by presentation_order, " + table1 + ".etc_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, context_id);
			stmt.setLong(index++, parent_etc_id);

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbMainEtcObj> relist = new ArrayList<XbMainEtcObj>();
			while(rs.next()) {
				XbMainEtcObj obj = new XbMainEtcObj();
				obj.setMain_id(rs.getLong("main_id"));
				obj.setEtc_type(rs.getInt("etc_type"));
				obj.setEtc_id(rs.getLong("etc_id"));
				obj.setParent_etc_id(rs.getLong("parent_etc_id"));
				obj.setEtc_name(rs.getString("etc_name"));
				obj.setName(rs.getString("name"));
				obj.setValue(rs.getString("value"));
				obj.setPresentation_order(rs.getLong("presentation_order"));
				obj.setCreation_date(rs.getDate("creation_date"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public XbMainEtcObj select(
			long context_id,
			long parent_etc_id,
			long etc_id
			
		) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("main_id, ");
			strb_sql.append(table1 + ".etc_type, ");
			strb_sql.append(table1 + ".etc_id, ");
			strb_sql.append("parent_etc_id, ");
			strb_sql.append("etc_name, ");
			strb_sql.append("name, ");
			strb_sql.append("value, ");
			strb_sql.append("presentation_order, ");
			strb_sql.append(table1 + ".creation_date ");
			strb_sql.append("from " + table1 + ", " + table2 + " ");
			strb_sql.append("where main_id=? ");
			strb_sql.append("and parent_etc_id=? ");
			strb_sql.append("and " + table1 + ".etc_id=? ");
			strb_sql.append("and " + table1 + ".etc_type=" + table2 + ".etc_type ");
			strb_sql.append("and " + table1 + ".etc_id=" + table2 + ".etc_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, context_id);
			stmt.setLong(index++, parent_etc_id);
			stmt.setLong(index++, etc_id);

			ResultSet rs = stmt.executeQuery();
			XbMainEtcObj obj = null;
			while(rs.next()) {
				obj = new XbMainEtcObj();
				obj.setMain_id(rs.getLong("main_id"));
				obj.setEtc_type(rs.getInt("etc_type"));
				obj.setEtc_id(rs.getLong("etc_id"));
				obj.setParent_etc_id(rs.getLong("parent_etc_id"));
				obj.setEtc_name(rs.getString("etc_name"));
				obj.setName(rs.getString("name"));
				obj.setValue(rs.getString("value"));
				obj.setPresentation_order(rs.getLong("presentation_order"));
				obj.setCreation_date(rs.getDate("creation_date"));
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return obj;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}
}