/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbItemObj;

/**
 * @author Masako Okayasu
 */
public class XbItemDao {

	// singleton쐬
    private static XbItemDao item = null;
    // Connectionϐ
    private static Connection conn = null;
	// Xe[gg쐬
    private PreparedStatement stmt;

    // e[u
	private String table1 = "xb_item";
	private String table2 = "xb_mapping";

    // RXgN^
    public XbItemDao(){
    }

    // CX^X擾
    public static synchronized XbItemDao getInstance(Connection connection){
    	//  CX^X𐶐
    	if(item == null) {
    		conn = connection;
    		item = new XbItemDao();
    	}

    	return item;
    }

	public void insert(XbItemObj obj) throws XbException{

		try {
			StringBuffer strb_sql = new StringBuffer();
		    // ⍇̎s
	    	strb_sql.append("insert into ");
	    	strb_sql.append(table1 + " ");
	    	strb_sql.append("values ");
	    	strb_sql.append("(?,?,?,?,?,?,?,?,?,?)");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, obj.getItem_order());
			stmt.setLong(index++, obj.getTaxonomy_group_id());
			stmt.setLong(index++, obj.getTaxonomy_id());
			stmt.setLong(index++, obj.getTaxonomy_item_id());
			stmt.setString(index++, obj.getItem_type());
			stmt.setLong(index++, obj.getParent_taxonomy_item_id());
			stmt.setString(index++, obj.getParent_item_type());
			stmt.setString(index++, obj.getPresentation_order());
			stmt.setString(index++, obj.getItem_lang());
			stmt.setString(index++, obj.getItem_name());

		   	// SQL@s
		   	stmt.executeUpdate();

		    // Xe[ggN[Y
		    stmt.close(); 

		} catch (SQLException e) {
	        throw new XbException(e, "SQLError : " + e.getMessage());
	    }
	}

	public ArrayList<XbItemObj> selectAll(
			long taxonomy_group_id,
			long parent_taxonomy_item_id,
			String item_lang
		) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("item_order, ");
			strb_sql.append("taxonomy_group_id, ");
			strb_sql.append("taxonomy_id, ");
			strb_sql.append("taxonomy_item_id, ");
			strb_sql.append("item_type, ");
			strb_sql.append("parent_taxonomy_item_id, ");
			strb_sql.append("parent_item_type, ");
			strb_sql.append("presentation_order, ");
			strb_sql.append("item_lang, ");
			strb_sql.append("item_name ");
			strb_sql.append("from " + table1 + " ");
			strb_sql.append("where taxonomy_group_id=? ");
			strb_sql.append("and parent_taxonomy_item_id=? ");
			strb_sql.append("and item_lang=? ");
			strb_sql.append("order by item_order ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, taxonomy_group_id);
			stmt.setLong(index++, parent_taxonomy_item_id);
			stmt.setString(index++, item_lang);

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbItemObj> relist = new ArrayList<XbItemObj>();
			while(rs.next()) {
				XbItemObj obj = new XbItemObj();
				obj.setItem_order(rs.getLong("item_order"));
				obj.setTaxonomy_group_id(rs.getLong("taxonomy_group_id"));
				obj.setTaxonomy_id(rs.getLong("taxonomy_id"));
				obj.setTaxonomy_item_id(rs.getLong("taxonomy_item_id"));
				obj.setItem_type(rs.getString("item_type"));
				obj.setParent_taxonomy_item_id(rs.getLong("parent_taxonomy_item_id"));
				obj.setParent_item_type(rs.getString("parent_item_type"));
				obj.setPresentation_order(rs.getString("presentation_order"));
				obj.setItem_lang(rs.getString("item_lang"));
				obj.setItem_name(rs.getString("item_name"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLError : " + e.getMessage());
	    }
	}

	public XbItemObj select(
			long taxonomy_group_id,
			long taxonomy_item_id,
			String item_lang
		) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("item_order, ");
			strb_sql.append("taxonomy_group_id, ");
			strb_sql.append("taxonomy_id, ");
			strb_sql.append("taxonomy_item_id, ");
			strb_sql.append("item_type, ");
			strb_sql.append("parent_taxonomy_item_id, ");
			strb_sql.append("parent_item_type, ");
			strb_sql.append("presentation_order, ");
			strb_sql.append("item_lang, ");
			strb_sql.append("item_name ");
			strb_sql.append("from " + table1 + " ");
			strb_sql.append("where taxonomy_group_id=? ");
			strb_sql.append("and taxonomy_item_id=? ");
			strb_sql.append("and item_lang=? ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, taxonomy_group_id);
			stmt.setLong(index++, taxonomy_item_id);
			stmt.setString(index++, item_lang);

			ResultSet rs = stmt.executeQuery();
			XbItemObj obj = null;
			while(rs.next()) {
				obj = new XbItemObj();
				obj.setItem_order(rs.getLong("item_order"));
				obj.setTaxonomy_group_id(rs.getLong("taxonomy_group_id"));
				obj.setTaxonomy_id(rs.getLong("taxonomy_id"));
				obj.setTaxonomy_item_id(rs.getLong("taxonomy_item_id"));
				obj.setItem_type(rs.getString("item_type"));
				obj.setParent_taxonomy_item_id(rs.getLong("parent_taxonomy_item_id"));
				obj.setParent_item_type(rs.getString("parent_item_type"));
				obj.setPresentation_order(rs.getString("presentation_order"));
				obj.setItem_lang(rs.getString("item_lang"));
				obj.setItem_name(rs.getString("item_name"));
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return obj;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLError : " + e.getMessage());
	    }
	}

	public ArrayList<XbItemObj> selectTuple(
			long taxonomy_group_id,
			String item_lang
		) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("item_order, ");
			strb_sql.append(table1 + ".taxonomy_group_id, ");
			strb_sql.append(table1 + ".taxonomy_item_id, ");
			strb_sql.append("parent_taxonomy_item_id, ");
			strb_sql.append("user_item_id, ");
			strb_sql.append("item_type, ");
			strb_sql.append("item_name ");
			strb_sql.append("from " + table1 + ", ");
			strb_sql.append(table2 + " ");
			strb_sql.append("where " + table1 + ".taxonomy_group_id=? ");
			strb_sql.append("and " + table1 + ".taxonomy_group_id=" + table2 + ".taxonomy_group_id ");
			strb_sql.append("and " + table1 + ".taxonomy_item_id=" + table2 + ".taxonomy_item_id ");
			strb_sql.append("and item_lang=? ");
			strb_sql.append("and tuple_child_flag=1 ");
			strb_sql.append("order by item_order ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, taxonomy_group_id);
			stmt.setString(index++, item_lang);

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbItemObj> relist = new ArrayList<XbItemObj>();
			while(rs.next()) {
				XbItemObj obj = new XbItemObj();
				obj.setItem_order(rs.getLong("item_order"));
				obj.setTaxonomy_group_id(rs.getLong("taxonomy_group_id"));
				obj.setTaxonomy_item_id(rs.getLong("taxonomy_item_id"));
				obj.setParent_taxonomy_item_id(rs.getLong("parent_taxonomy_item_id"));
				obj.setUser_item_id(rs.getLong("user_item_id"));
				obj.setItem_type(rs.getString("item_type"));
				obj.setItem_name(rs.getString("item_name"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLError : " + e.getMessage());
	    }
	}
}