/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbIdentifierObj;

/**
 * @author Masako Okayasu
 */
public class XbIdentifierDao {

	// singleton쐬
    private static XbIdentifierDao identifier = null;
    // Connectionϐ
    private static Connection conn = null;
	// Xe[gg쐬
    private PreparedStatement stmt;

    // RXgN^
    public XbIdentifierDao(){
    }

    // CX^X擾
    public static synchronized XbIdentifierDao getInstance(Connection connection){
    	// CX^X𐶐
        if(identifier == null) {
            conn = connection;
            identifier = new XbIdentifierDao();
        }

        return identifier;
    }

	public void insert(XbIdentifierObj obj) throws XbException{

		try {
			StringBuffer strb_sql = new StringBuffer();
		    // ⍇̎s
	    	strb_sql.append("insert into ");
	    	strb_sql.append("xb_identifier ");
	    	strb_sql.append("values ");
	    	strb_sql.append("(?,?,?,?,?)");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, obj.getIdentifier_id());
			stmt.setString(index++, obj.getIdentifier_name());
			stmt.setString(index++, obj.getSchema());
			stmt.setString(index++, obj.getValue());
	        stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

		   	// SQL@s
		   	stmt.executeUpdate();

		    // Xe[ggN[Y
		    stmt.close(); 

		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public ArrayList<XbIdentifierObj> selectAll() throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("identifier_id, ");
			strb_sql.append("identifier_name, ");
			strb_sql.append("schema, ");
			strb_sql.append("value, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_identifier ");
			strb_sql.append("order by identifier_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbIdentifierObj> relist = new ArrayList<XbIdentifierObj>();
			while(rs.next()) {
				XbIdentifierObj obj = new XbIdentifierObj();
				obj.setIdentifier_id(rs.getLong("identifier_id"));
				obj.setIdentifier_name(rs.getString("identifier_name"));
				obj.setSchema(rs.getString("schema"));
				obj.setValue(rs.getString("value"));
				obj.setCreation_date(rs.getDate("creation_date"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public XbIdentifierObj select(long identifier_id) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("identifier_id, ");
			strb_sql.append("identifier_name, ");
			strb_sql.append("schema, ");
			strb_sql.append("value, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_identifier ");
			strb_sql.append("where identifier_id=? ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, identifier_id);

			ResultSet rs = stmt.executeQuery();
			XbIdentifierObj obj = null;
			while(rs.next()) {
				obj = new XbIdentifierObj();
				obj.setIdentifier_id(rs.getLong("identifier_id"));
				obj.setIdentifier_name(rs.getString("identifier_name"));
				obj.setSchema(rs.getString("schema"));
				obj.setValue(rs.getString("value"));
				obj.setCreation_date(rs.getDate("creation_date"));
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return obj;
		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public long getNextId() throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("max(identifier_id)+1 as max ");
			strb_sql.append("from xb_identifier ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			ResultSet rs = stmt.executeQuery();
			rs.next();

			return (rs.getLong("max")==0 ? 1 : rs.getLong("max"));
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}
}