/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbEntityObj;

/**
 * @author Masako Okayasu
 */
public class XbEntityDao {

	// singleton쐬
    private static XbEntityDao entity = null;
    // Connectionϐ
    private static Connection conn = null;
	// Xe[gg쐬
    private PreparedStatement stmt;

    // RXgN^
    public XbEntityDao(){
    }

    // CX^X擾
    public static synchronized XbEntityDao getInstance(Connection connection){
    	//  CX^X𐶐
    	if(entity == null) {
    		conn = connection;
    		entity = new XbEntityDao();
    	}

    	return entity;
    }

	public void insert(XbEntityObj obj) throws XbException{

		try {
			StringBuffer strb_sql = new StringBuffer();
		    // ⍇̎s
	    	strb_sql.append("insert into ");
	    	strb_sql.append("xb_entity ");
	    	strb_sql.append("values ");
	    	strb_sql.append("(?,?,?,?)");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, obj.getEntity_id());
			stmt.setString(index++, obj.getEntity_name());
			stmt.setLong(index++, obj.getPresentation_order());
	        stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

		   	// SQL@s
		   	stmt.executeUpdate();

		    // Xe[ggN[Y
		    stmt.close(); 

		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public ArrayList<XbEntityObj> selectAll() throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("entity_id, ");
			strb_sql.append("entity_name, ");
			strb_sql.append("presentation_order, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_entity ");
			strb_sql.append("order by presentation_order, entity_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbEntityObj> relist = new ArrayList<XbEntityObj>();
			while(rs.next()) {
				XbEntityObj obj = new XbEntityObj();
				obj.setEntity_id(rs.getInt("entity_id"));
				obj.setEntity_name(rs.getString("entity_name"));
				obj.setPresentation_order(rs.getLong("presentation_order"));
				obj.setCreation_date(rs.getDate("creation_date"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public XbEntityObj select(long entity_id) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("entity_id, ");
			strb_sql.append("entity_name, ");
			strb_sql.append("presentation_order, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_entity ");
			strb_sql.append("where entity_id=? ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, entity_id);

			ResultSet rs = stmt.executeQuery();
			XbEntityObj obj = null;
			while(rs.next()) {
				obj = new XbEntityObj();
				obj.setEntity_id(rs.getInt("entity_id"));
				obj.setEntity_name(rs.getString("entity_name"));
				obj.setPresentation_order(rs.getLong("presentation_order"));
				obj.setCreation_date(rs.getDate("creation_date"));
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return obj;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public long getNextId() throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("max(entity_id)+1 as max ");
			strb_sql.append("from xb_entity ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			ResultSet rs = stmt.executeQuery();
			rs.next();

			return (rs.getLong("max")==0 ? 1 : rs.getLong("max"));
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}
}