/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
class XbRootElementDAO {

    // singleton쐬
    private static XbRootElementDAO instance = null;
    private static Connection conn = null;

    // RXgN^
    private XbRootElementDAO() {
    }

    // CX^X擾
    public static synchronized XbRootElementDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (instance == null) {
            conn = connection;
            instance = new XbRootElementDAO();
        }

        return instance;
    }

    protected ArrayList<XbRootElementObj> getRootAttr(String versions) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("namespace ");
            strb_sql.append(", namespace_url ");
            strb_sql.append("from ");
            strb_sql.append("xb_base_schema ");
            strb_sql.append("where ");
            strb_sql.append("specification_no = ? ");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index++, versions);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbRootElementObj> relist = new ArrayList<XbRootElementObj>();
            while(rs.next()) {
                // TuXg
                XbRootElementObj obj = new XbRootElementObj();
                obj.setNamespace(rs.getString("namespace"));
                obj.setNamespaceUrl(rs.getString("namespace_url"));

                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}