/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
abstract class XbRootElement extends XbContext {

    protected void addNameSpace(ArrayList<XbRootElementObj> objList, Element rootElement) {
        // OԒǉ
        for (int i = 0;i < objList.size();i ++) {
            XbRootElementObj obj = objList.get(i);

            if (!obj.getNamespace().equals(XbConstants.XMLNS_XL)) {
                super.setAttribute(rootElement, obj.getNamespace(), obj.getNamespaceUrl());
            }
        }
    }

    abstract protected Element createRootElement(Connection conn, Document doc) throws XbException;
}