/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
class XbItemSearchInfoDAO {

    // singleton쐬
    private static XbItemSearchInfoDAO instance = null;
    private static Connection conn = null;

    // RXgN^
    private XbItemSearchInfoDAO() {
    }

    // CX^X擾
    protected static synchronized XbItemSearchInfoDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (instance == null) {
            conn = connection;
            instance = new XbItemSearchInfoDAO();
        }

        return instance;
    }

    protected String getEntityName(String entityId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("entity_name ");
            strb_sql.append("from ");
            strb_sql.append("xb_entity ");
            strb_sql.append("where ");
            strb_sql.append("entity_id = ? ");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index++, entityId);

            ResultSet rs = stmt.executeQuery();

            String entity = "";
            if(rs.next()) {
                // TuXg
                entity = rs.getString("entity_name");
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return entity;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }

    protected XbItemSearchUnitObj getUnitName(String contextId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("u.unit_name as unit_name ");
            strb_sql.append(", u.name as name ");
            strb_sql.append("from ");
            strb_sql.append("xb_context_unit cu ");
            strb_sql.append(", xb_unit u ");
            strb_sql.append("where ");
            strb_sql.append("cu.context_id = ? ");
            strb_sql.append("and cu.unit_id = u.unit_id ");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index++, contextId);

            ResultSet rs = stmt.executeQuery();

            XbItemSearchUnitObj obj = new XbItemSearchUnitObj();
            if(rs.next()) {
                // TuXg
                obj.setUnitName(rs.getString("unit_name"));
                obj.setName(rs.getString("name"));
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}