/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbInstanceRefAttrDAO {

    // singleton쐬
    private static XbInstanceRefAttrDAO instance = null;
    private static Connection conn = null;

    // RXgN^
    private XbInstanceRefAttrDAO() {
    }

    // CX^X擾
    public static synchronized XbInstanceRefAttrDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (instance == null) {
            conn = connection;
            instance = new XbInstanceRefAttrDAO();
        }

        return instance;
    }

    protected ArrayList<XbInstanceRefAttrObj> getInstanceRefAttr(String refType, String refId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("ref_type, ");
            strb_sql.append("ref_id, ");
            strb_sql.append("name, ");
            strb_sql.append("value ");
            strb_sql.append("from ");
            strb_sql.append("xb_ref_attributes ");
            strb_sql.append("where ");
            strb_sql.append("ref_type = ? ");
            strb_sql.append("and ref_id = ? ");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index++, refType);
            stmt.setString(index++, refId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbInstanceRefAttrObj> relist = new ArrayList<XbInstanceRefAttrObj>();
            while(rs.next()) {
                // TuXg
                XbInstanceRefAttrObj obj = new XbInstanceRefAttrObj();
                obj.setRefType(rs.getString("ref_type"));
                obj.setRefId(rs.getString("ref_id"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}