/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbContextIdList;
import jp.co.going.xbrl.common.XbRefList;
import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.parse.XbPAOImpl;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
abstract class XbInstance {

    private XbItemSearchInfoDAO searchDAO;
    private XbInterfaceDAO interfaceDAO;
    private XbTupleDataDAO tupleDataDAO;
    private ArrayList<XbTupleDataObj> tupleList;

    protected String entity;
    protected XbItemSearchUnitObj unit;
    protected XbFootNote footnote;
    protected XbMappingDAO mappingDAO;
    protected XbContextDAO contextDAO;
    protected XbContext context;
    protected Document doc;
    protected Connection conn;
    protected ArrayList<XbMappingObj> mappongList;
    protected ArrayList<String> footNoteIdList;

    protected XbInstance(Connection conn) throws XbException {
        this.conn = conn;
        contextDAO = XbContextDAO.getInstance(conn);
        // hLg쐬
        XbPAOImpl parser = new XbPAOImpl();
        doc = parser.getDocumentBuilder().newDocument();

        searchDAO = XbItemSearchInfoDAO.getInstance(conn);
        tupleDataDAO = XbTupleDataDAO.getInstance(conn);
        interfaceDAO = XbInterfaceDAO.getInstance(conn);

        footNoteIdList = new ArrayList<String>();
        footnote = new XbFootNote(conn, doc);
    }

    /**
     * interfacee[u폜
     * @throws XbException
     */
    protected void clearInterface()  throws XbException {
        // interfacee[uNA
        interfaceDAO.delete();
    }

    /**
     * 擾
     * @throws XbException
     */
    protected void getSearchInfo(XbContextObj obj) throws XbException {
        // itempentity
        entity = searchDAO.getEntityName(obj.getEntityId());
        // itempunit
        unit = searchDAO.getUnitName(obj.getContextId());
    }

    /**
     * tupleData擾
     * @throws XbException
     */
    protected void getTupleData(String groupId, XbContextObj context) throws XbException {
        tupleList = tupleDataDAO.getTupleData(groupId, context.getContextId());
        // tupleInsert
        for (int i = 0;i < tupleList.size();i ++) {
            interfaceDAO.insertTuple(tupleList.get(i), context.getName(), unit.getName());
        }
    }

    /**
     * interfacee[uɓo^
     * @throws XbException
     */
    protected void setContextItem(ArrayList<XbMappingObj> obj, XbContextObj context) throws XbException {
        for (int i = 0;i < obj.size();i ++) {
            // 擾ACee[uɊi[
            interfaceDAO.insertItem(obj.get(i), context.getName(), unit.getName());
        }
    }

    /**
     * footnoteIdXg쐬
     *
     */
    protected void addFootNoteId() {
        for (int i = 0;i < mappongList.size();i ++) {
            if (mappongList.get(i).getParentEtcId() != null && !footNoteIdList.contains(mappongList.get(i).getParentEtcId())) {
                footNoteIdList.add(mappongList.get(i).getParentEtcId());
            }
        }
        for (int i = 0;i < tupleList.size();i ++) {
            if (tupleList.get(i).getParentEtcId() != null && !footNoteIdList.contains(tupleList.get(i).getParentEtcId())) {
                footNoteIdList.add(tupleList.get(i).getParentEtcId());
            }
        }
    }

    protected void createFootNote(String taxGroupId, Element rootElement) throws XbException {
        for (int i = 0;i < footNoteIdList.size();i ++) {
            footnote.createFootNote(taxGroupId, footNoteIdList.get(i), rootElement);
        }
    }

    /**
     * CX^X쐬
     * @param taxGroupId
     * @param contextIdList
     * @param refList
     * @return
     * @throws XbException
     */
    abstract protected Document createInstance(String taxGroupId, XbContextIdList contextIdList, XbRefList refList) throws XbException;
}