/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
class XbFootNoteDAO extends XbEtcDAO {

    // singleton쐬
    private static XbFootNoteDAO instance = null;
    private static Connection conn = null;

    // RXgN^
    private XbFootNoteDAO() {
    }

    // CX^X擾
    protected static synchronized XbFootNoteDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (instance == null) {
            conn = connection;
            instance = new XbFootNoteDAO();
        }

        return instance;
    }

    protected ArrayList<XbEtcObj> getFootNote(String taxGroupId, String etcId, String pEtcId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("foot.etc_type as etc_type ");
            strb_sql.append(", foot.etc_id as etc_id ");
            strb_sql.append(", foot.parent_etc_id as parent_etc_id ");
            strb_sql.append(", etc.name as name ");
            strb_sql.append(", etc.value value ");
            strb_sql.append("from ");
            strb_sql.append("xb_item_footnote foot ");
            strb_sql.append(", xb_etc etc ");
            strb_sql.append("where ");
            strb_sql.append("foot.main_id = ? ");
            strb_sql.append("and foot.etc_type = etc.etc_type ");
            strb_sql.append("and foot.etc_id = etc.etc_id ");
            strb_sql.append("and foot.etc_id = ? ");
            strb_sql.append("and foot.parent_etc_id = ?");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index++, taxGroupId);
            stmt.setString(index++, etcId);
            stmt.setString(index++, pEtcId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEtcObj> relist = new ArrayList<XbEtcObj>();
            while(rs.next()) {
                // TuXg
                XbEtcObj obj = new XbEtcObj();
                obj.setEtcId(rs.getString("etc_id"));
                obj.setParentEtcId(rs.getString("parent_etc_id"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setAttrList(super.getEtcAttributes(conn, rs.getString("etc_type"), rs.getString("etc_id")));
                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }

    protected ArrayList<XbEtcObj> getEtc(String etcId, String pEtcId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("foot.etc_type as etc_type ");
            strb_sql.append(", foot.etc_id as etc_id ");
            strb_sql.append(", foot.parent_etc_id as parent_etc_id ");
            strb_sql.append(", etc.name as name ");
            strb_sql.append(", etc.value value ");
            strb_sql.append("from ");
            strb_sql.append("xb_item_footnote foot ");
            strb_sql.append(", xb_etc etc ");
            strb_sql.append("where ");
            strb_sql.append("foot.main_id = ? ");
            strb_sql.append("and foot.etc_type = etc.etc_type ");
            strb_sql.append("and foot.etc_id = etc.etc_id ");
            strb_sql.append("and foot.parent_etc_id = ?");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index++, etcId);
            stmt.setString(index++, pEtcId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEtcObj> relist = new ArrayList<XbEtcObj>();
            while(rs.next()) {
                // TuXg
                XbEtcObj obj = new XbEtcObj();
                obj.setEtcId(rs.getString("etc_id"));
                obj.setParentEtcId(rs.getString("parent_etc_id"));
                obj.setName(rs.getString("name"));
                obj.setValue(rs.getString("value"));
                obj.setAttrList(super.getEtcAttributes(conn, rs.getString("etc_type"), rs.getString("etc_id")));
                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}