/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
abstract class XbEtcDAO {

    protected ArrayList<XbEtcAttrObj> getEtcAttributes(Connection conn, String etcType, String etcId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("etc_type ");
            strb_sql.append(", etc_id ");
            strb_sql.append(", name ");
            strb_sql.append(", value ");
            strb_sql.append("from ");
            strb_sql.append("xb_etc_attributes ");
            strb_sql.append("where ");
            strb_sql.append("etc_type = ? ");
            strb_sql.append("and etc_id = ? ");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index++, etcType);
            stmt.setString(index++, etcId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEtcAttrObj> relist = new ArrayList<XbEtcAttrObj>();
            while(rs.next()) {
                // TuXg
                XbEtcAttrObj obj = new XbEtcAttrObj();
                obj.setEtcAttrType(rs.getString("etc_type"));
                obj.setEtcAttrId(rs.getString("etc_id"));
                obj.setEtcAttrName(rs.getString("name"));
                obj.setEtcAttrValue(rs.getString("value"));

                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }

    abstract protected ArrayList<XbEtcObj> getEtc(String id, String pId) throws XbException;

    protected ArrayList<XbEtcObj> getFootNote(String taxGroupId, String etcId, String pEtcId) throws XbException {
        return null;
    }
}