/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
class XbContextUnitDAO {
    // singleton쐬
    private static XbContextUnitDAO instance = null;
    private static Connection conn = null;

    // RXgN^
    private XbContextUnitDAO() {
    }

    // CX^X擾
    protected static synchronized XbContextUnitDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (instance == null) {
            conn = connection;
            instance = new XbContextUnitDAO();
        }

        return instance;
    }

    protected XbContextUnitObj getUnitInfo(String contextId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("cu.unit_id as unit_id ");
            strb_sql.append(", u.name as name ");
            strb_sql.append("from ");
            strb_sql.append("xb_context_unit cu ");
            strb_sql.append(", xb_unit u ");
            strb_sql.append("where ");
            strb_sql.append("cu.context_id = ? ");
            strb_sql.append("and cu.unit_id = u.unit_id");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index ++, contextId);

            ResultSet rs = stmt.executeQuery();

            XbContextUnitObj obj = null;
            if (rs.next()) {
                // TuXg
                obj = new XbContextUnitObj();
                obj.setUnitId(rs.getString("unit_id"));
                obj.setName(rs.getString("name"));
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}