/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.common.parse;

import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

/**
 * p[XG[nhONXł
 * @author Masako Okayasu
 */
public class XbPAOError implements ErrorHandler {

    public void warning(SAXParseException e) {
        System.out.println("x: " + e.getLineNumber() +"s");
        System.out.println(e.getMessage());
    }

    public void error(SAXParseException e) {
        System.out.println("G[: " + e.getLineNumber() +"s");
        System.out.println(e.getMessage());
    }

    public void fatalError(SAXParseException e) {
    	System.out.println("[ȃG[: " + e.getLineNumber() +"s");
    	System.out.println(e.getMessage());
    }
}
