/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * waqkŎgp^caɓo^NX
 * 
 * @author Going Dot Com Inc.
 */
class XbItemTypeDAO {

    // singleton쐬
    private static XbItemTypeDAO taxGrp = null;
    // Connectionϐ
    private static Connection conn = null;
    // Xe[gg
    private PreparedStatement stmt;

    // RXgN^
    private XbItemTypeDAO() {
    }

    // CX^X擾
    protected static synchronized XbItemTypeDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (taxGrp == null) {
            conn = connection;
            taxGrp = new XbItemTypeDAO();
        }

        return taxGrp;
    }

	protected int select(String strTypeName, String strVerSion) throws XbException {

        try {
            StringBuffer  strb_sql = new StringBuffer();

    		// CXg
    		int relist = 0;
    		strb_sql.append("select ");
    		strb_sql.append("type_name, ");
    		strb_sql.append("attribute_name, ");
    		strb_sql.append("specification_no, ");
    		strb_sql.append("creation_date ");
    		strb_sql.append("from xb_item_type ");
    		strb_sql.append("where type_name = ? ");
    		strb_sql.append("and specification_no = ?");
    		// SQLݒ
    		stmt = conn.prepareStatement(strb_sql.toString());
    		int index = 1;
    		stmt.setString(index++, strTypeName);
    		stmt.setString(index++, strVerSion);

    		ResultSet rs = stmt.executeQuery();
    		while(rs.next()) {
                relist ++;
            }

    	    // ʃZbgN[Y
    	    rs.close(); 
    	    // Xe[ggN[Y
    	    stmt.close(); 

    	    return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
	}	

    protected void insert(XbItemTypeObj obj) throws XbException {

        try {
            StringBuffer  strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("insert into ");
            strb_sql.append("xb_item_type ");
            strb_sql.append("values ");
            strb_sql.append("(?, ?, ?, ?)");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setString(index++, obj.getType_name());
            stmt.setString(index++, obj.getAttribute_name());
            stmt.setString(index++, obj.getSpecification_no());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();

            // Xe[ggN[Y
            stmt.close();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}