/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * {XL[}caɓo^NX
 * 
 * @author Going Dot Com Inc.
 */
class XbBaseSchemaDAO {

    // singleton쐬
    private static XbBaseSchemaDAO taxGrp = null;
    // Connectionϐ
    private static Connection conn = null;
    // Xe[gg
    private PreparedStatement stmt;

    // RXgN^
    private XbBaseSchemaDAO() {
    }

    // CX^X擾
    protected static synchronized XbBaseSchemaDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (taxGrp == null) {
            conn = connection;
            taxGrp = new XbBaseSchemaDAO();
        }

        return taxGrp;
    }

	protected int select(String strNodeName, String strVerSion) throws XbException {

        try {
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
    		int relist = 0;
    		strb_sql.append("select ");
    		strb_sql.append("namespace, ");
    		strb_sql.append("namespace_url, ");
    		strb_sql.append("specification_no, ");
    		strb_sql.append("creation_date ");
    		strb_sql.append("from xb_base_schema ");
    		strb_sql.append("where namespace = ? ");
    		strb_sql.append("and specification_no = ?");
    		// SQLݒ
    		stmt = conn.prepareStatement(strb_sql.toString());
    		int index = 1;
    		stmt.setString(index++, strNodeName);
    		stmt.setString(index++, strVerSion);

    		ResultSet rs = stmt.executeQuery();
    		while(rs.next()) {
                relist ++;
    		}

    	    // ʃZbgN[Y
    	    rs.close(); 

    	    // Xe[ggN[Y
    	    stmt.close(); 

    	    return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
	}

    protected void insert(XbBaseSchemaObj obj) throws XbException {

        try {
            StringBuffer  strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("insert into ");
            strb_sql.append("xb_base_schema ");
            strb_sql.append("values ");
            strb_sql.append("(?, ?, ?, ?)");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setString(index++, obj.getNamespace());
            stmt.setString(index++, obj.getNamespace_url());
            stmt.setString(index++, obj.getSpecification_no());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

            // SQL@s
            stmt.executeUpdate();

            // Xe[ggN[Y
            stmt.close();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}