--==============================================================
--  Database name:  XBRL TOOL SCHEMAS
--  DBMS name:      ORACLE Version 10g
--  Created on:     2007-05-16 XX:XX:XX
--  Description:    XBRL Reportp̃e[u쐬܂
--==============================================================

----------------------------------------------------------------
--- <e[uꗗ>
---   xb_base_schema                {XL[}e[u
---   xb_item_type                  ڌ^e[u
---   xb_taxonomy_group             ^N\m~[O[ve[u
---   xb_taxonomy                   ^N\m~[e[u
---   xb_linkbaseref                QƃNx[Xe[u
---   xb_linkbase_arc               A[Ne[u
---   xb_linkbase_locator           P[^e[u
---   xb_linkbase_resource          Nx[X\[Xe[u
---   xb_resource_item              \[XACee[u
---   xb_resource_item_attr         \[XACee[u
---   xb_taxonomy_item              ^N\m~[Ȗڃe[u
---   xb_item_label                 ACexe[u
---   xb_item_work                  ACeI[_[[Ne[u
---   xb_item_top                   ACe[ge[u
---   xb_item                       ACeI[_[e[u
---   xb_interface                  C^[tF[Xe[u
---   xb_item_interface             ACeC^[tF[Xe[u
----------------------------------------------------------------

--------------------------------------------------
--- Taxonomy n
--------------------------------------------------

--- <<{XL[}e[u>>
---   {XL[}̖Oԋyюʎq(OURL)Ǘ
create table xb_base_schema
(
  namespace             varchar(256) not null,
  namespace_url         varchar(512) not null,
  specification_no      varchar(3) not null,
  creation_date         timestamp not null,
  constraint  pk_xb_base_schema primary key (namespace(255), specification_no(3))
)
;

--- <<ڌ^e[u>>
---   XBRLŎgp^̈ꗗǗ
---   XBRLł͐l͔񐔒lǂ炩̒lŉ^p
create table xb_item_type
(
  type_name             varchar(256) not null,
  attribute_name        varchar(15) not null,
  specification_no      varchar(3) not null,
  creation_date         timestamp not null,
  constraint  pk_xb_item_type primary key (type_name, specification_no)
)
;

--- <<^N\m~[O[ve[u>>
---   ^N\m~[O[vۂ̊ǗPʃe[u
create table xb_taxonomy_group
(
  taxonomy_group_id     bigint not null,
  taxonomy_group_name   varchar(32) not null,
  specification_no      varchar(3) not null,
  note                  varchar(256),
  creation_date         timestamp not null,
  constraint pk_xb_taxonomy_group primary key (taxonomy_group_id)
)
;

--- <<^N\m~[e[u>>
---   ^N\m~[t@Citem(Ȗ)ȊȌ
create table xb_taxonomy
(
  taxonomy_id           bigint not null,
  taxonomy_group_id     bigint not null,
  taxonomy_name         varchar(128),
  taxonomy_file         varchar(128) not null,
  namespace             varchar(256) not null,
  namespace_url         varchar(512) not null,
  terminated_flag       tinyint,
  creation_date         timestamp not null,
  constraint pk_xb_taxonomy primary key (taxonomy_id),
  constraint fk_xb_taxonomy foreign key (taxonomy_group_id)
    references xb_taxonomy_group (taxonomy_group_id)
)
;

--- <<QƃNx[Xe[u>>
---   linkbaseRef^Ȍi[
create table xb_linkbaseref
(
  linkbaseref_id        bigint not null,
  linkbase_role         varchar(128) not null,
  linkbase_href         varchar(256),
  taxonomy_id           bigint not null,
  taxonomy_group_id     bigint not null,
  category              varchar(64),
  creation_date         timestamp not null,
  constraint pk_xb_linkbaseref primary key (linkbaseref_id),
  constraint fk_xb_tax_linkbaseref foreign key (taxonomy_id)
    references xb_taxonomy (taxonomy_id),
  constraint fk_xb_tax_group_linkbaseref foreign key (taxonomy_group_id)
    references xb_taxonomy_group (taxonomy_group_id)
)
;

--- <<A[Ne[u>>
---   eNx[X̃A[Ni[
create table xb_linkbase_arc
(
  arc_id                        bigint not null,
  linkbaseref_id                bigint not null,
  arc_show                      varchar(10),
  arc_title                     varchar(512),
  arc_from                      varchar(256),
  arc_to                        varchar(256),
  arc_arcrole                   varchar(256),
  arc_use                       varchar(20),
  arc_priority                  bigint ,
  calculation_weight            float(10,4),
  presentation_order            float(10,4),
  constraint pk_xb_linkbase_arc primary key (arc_id),
  constraint fk_xb_arc_linkbase_ref foreign key (linkbaseref_id)
    references xb_linkbaseref (linkbaseref_id)
)
;

--- <<P[^e[u>>
---   eNx[X̃P[^i[
create table xb_linkbase_locator
(
  locator_id                    bigint not null,
  linkbaseref_id                bigint not null,
  loc_href                      varchar(256) not null,
  loc_identifier                varchar(256) not null,
  loc_label                     varchar(256),
  loc_title                     varchar(512),
  loc_role                      varchar(256),
  constraint pk_xb_linkbase_loc primary key (locator_id),
  constraint fk_xb_loc_linkbase_ref foreign key (linkbaseref_id)
    references xb_linkbaseref (linkbaseref_id)
)
;

--- <<\[Xe[u>>
---   eNx[X̃\[Xi[
---   ɃxNƃt@XNY
create table xb_linkbase_resource
(
  resource_id                   bigint not null,
  linkbaseref_id                bigint not null,
  resource_label                varchar(256),
  resource_title                varchar(512),
  label_role                    varchar(256),
  label_lang                    varchar(8),
  resource_value                longtext,
  constraint pk_xb_linkbase_resource primary key (resource_id),
  constraint fk_xb_resource_linkbase_ref foreign key (linkbaseref_id)
    references xb_linkbaseref (linkbaseref_id)
)
;

--- <<\[XACee[u>>
---   \[X̒l^Ovf̏ꍇÃe[uɏi[
create table xb_resource_item
(
  resource_item_id              bigint not null,
  resource_id                   bigint not null,
  namespace                     varchar(256),
  namespace_url                 varchar(512),
  item_name                     varchar(512),
  item_value                    longtext,
  constraint pk_xb_resource_item primary key (resource_item_id),
  constraint fk_xb_resource_item foreign key (resource_id)
    references xb_linkbase_resource (resource_id)
)
;

--- <<\[XACee[u>>
---   \[X̒l^Ovf̏ꍇÃe[uɏi[()
create table xb_resource_item_attr
(
  resource_item_attr_id         bigint not null,
  resource_item_id              bigint not null,
  attribute_name                varchar(512),
  attribute_value               varchar(512),
  constraint pk_xb_resource_item_attr primary key (resource_item_attr_id),
  constraint fk_xb_resource_item_attr foreign key (resource_item_id)
    references xb_resource_item (resource_item_id)
)
;

--- <<^N\m~[Ȗڃe[u>>
---   XBRL̊ȖڌQ
create table xb_taxonomy_item
(
  taxonomy_item_id        bigint not null,
  taxonomy_id             bigint not null,
  taxonomy_group_id       bigint not null,
  item_id                 varchar(128),
  item_name               varchar(128),
  item_type               varchar(64),
  item_substitutiongroup  varchar(32),
  item_balance            varchar(10),
  item_nillable           tinyint,
  item_period_type        varchar(10),
  abstract                tinyint,
  documentation           longtext,
  creation_date           timestamp,
  constraint pk_xb_taxonomy_item primary key (taxonomy_item_id),
  constraint fk_item_taxonomy foreign key (taxonomy_id)
    references xb_taxonomy (taxonomy_id),
  constraint fk_item_taxonomy_group foreign key (taxonomy_group_id)
    references xb_taxonomy_group (taxonomy_group_id)
)
;

--- <<ACexe[u>>
--- ACẽxi[
create table xb_item_label
(
    taxonomy_group_id              bigint not null,
    taxonomy_id                    bigint not null,
    taxonomy_item_id               bigint not null,
    label_lang                     varchar(8),
    resource_value                 longtext
)
;

--- <<ACeI[_[[Ne[u>>
--- ACe̐eq֌Wƕяi[郏[Ne[u
create table xb_item_work
(
    taxonomy_group_id              bigint not null,
    taxonomy_id                    bigint not null,
    taxonomy_item_id               bigint not null,
    item_type                      varchar(32),
    parent_taxonomy_item_id        bigint not null,
    parent_item_type               varchar(32),
    context_type                   varchar(32),
    presentation_order             float(10,4)
)
;

--- <<ACe[ge[u>>
--- ACêi[
create table xb_item_top
(
    taxonomy_group_id              bigint not null,
    taxonomy_item_id               bigint not null,
    item_lang                      varchar(8),
    item_name                      longtext
)
;

--- <<ACeI[_[e[u>>
--- ACe̐eq֌Wƕяi[
create table xb_item
(
    item_order                     int not null,
    taxonomy_group_id              bigint not null,
    taxonomy_id                    bigint not null,
    taxonomy_item_id               bigint not null,
    item_type                      varchar(32),
    parent_taxonomy_item_id        bigint not null,
    parent_item_type               varchar(32),
    context_type                   varchar(32),
    presentation_order             float(10,4),
    item_lang                      varchar(8),
    item_name                      longtext,
    constraint pk_xb_item primary key (item_order, taxonomy_group_id, taxonomy_item_id, item_lang)
)
;

--- <<C^[tF[Xe[u>>
--- ACei[
create table xb_interface
(
    item_order                     int not null,
    taxonomy_item_id               bigint not null,
    taxonomy_item_seq              int not null,
    parent_taxonomy_item_id        bigint not null,
    parent_taxonomy_item_seq       int not null,
    item_value                     varchar(512),
    item_precision                 int,
    item_decimal                   int,
    context_type                   varchar(32),
    context_name                   varchar(128),
    unit_name                      varchar(128),
    footnote_value                 varchar(128)
)
;

--- <<ACeC^[tF[Xe[u>>
--- [U[ACei[
create table xb_item_interface
(
    user_item_id                   bigint not null,
    item_value                     varchar(512),
    entity                         varchar(128),
    period                         varchar(10),
    unit                           varchar(128)
)
;
create table xbrl.xb_context
(
    context_id                     bigint not null,
    context_type                   varchar(32) not null,
    context_name                   varchar(128) not null,
    name                           varchar(128) not null,
    entity_id                      bigint not null,
    fiscal_year                    int,
    period_start_date              varchar(10),
    period_end_date                varchar(10),
    item_precision                 int not null,
    item_cwa                       int not null,
    unit_flag                      tinyint not null,
    description                    varchar(512),
    creation_date                  timestamp not null
)
create unique index pk_xb_context on xbrl.xb_context
(context_id)
;
create table xbrl.xb_context_unit
(
    context_id                     bigint not null,
    unit_id                        bigint not null,
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_context_unit on xbrl.xb_context_unit
(context_id, unit_id)
;
create table xbrl.xb_unit
(
    unit_id                        bigint not null,
    unit_name                      varchar(128) not null,
    name                           varchar(128),
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_unit on xbrl.xb_unit
(unit_id)
;
create table xbrl.xb_unit_measure
(
    unit_id                        bigint not null,
    measure_id                     bigint not null,
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_unit_measure on xbrl.xb_unit_measure
(unit_id, measure_id)

create table xbrl.xb_unit_divide
(
    unit_id                        bigint not null,
    divide_id                      bigint not null,
    operator_type                  tinyint not null,
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_unit_divide on xbrl.xb_unit_divide
(unit_id, divide_id)
;
create table xbrl.xb_divide_measure
(
    divide_id                      bigint not null,
    divide_type                    tinyint not null,
    measure_id                     bigint not null,
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_divide_measure on xbrl.xb_divide_measure
(divide_id, divide_type, measure_id)
;
create table xbrl.xb_measure
(
    measure_id                     bigint not null,
    measure_name                   varchar(128) not null,
    money_flag                     tinyint not null,
    value                          varchar(128) not null,
    creation_date                  timestamp not null
)
create unique index pk_xb_measure on xbrl.xb_measure
(measure_id)
;
create table xbrl.xb_context_scenario
(
    main_id                        bigint not null,
    etc_type                       tinyint not null,
    etc_id                         bigint not null,
    parent_etc_id                  bigint not null,
    prefix                         varchar(128),
    uri                            varchar(512),
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_context_scenario on xbrl.xb_context_scenario
(main_id, etc_type, etc_id, parent_etc_id, prefix)

create table xbrl.xb_entity
(
    entity_id                      bigint not null,
    entity_name                    varchar(128) not null,
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_entity on xbrl.xb_entity
(entity_id)

create table xbrl.xb_entity_identifier
(
    entity_id                      bigint not null,
    identifier_id                  bigint not null,
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_entity_identifier on xbrl.xb_entity_identifier
(entity_id, identifier_id)
;
create table xbrl.xb_entity_segment
(
    main_id                        bigint not null,
    etc_type                       tinyint not null,
    etc_id                         bigint not null,
    parent_etc_id                  bigint not null,
    prefix                         varchar(128),
    uri                            varchar(512),
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_entity_segment on xbrl.xb_entity_segment
(main_id, etc_type, etc_id, parent_etc_id, prefix)

create table xbrl.xb_identifier
(
    identifier_id                  bigint not null,
    identifier_name                varchar(128) not null,
    schema                         varchar(512),
    value                          varchar(128) not null,
    creation_date                  timestamp not null
)
create unique index pk_xb_identifier on xbrl.xb_identifier
(identifier_id)
;
create table xbrl.xb_etc
(
    etc_type                       tinyint not null,
    etc_id                         bigint not null,
    etc_name                       varchar(128) not null,
    name                           varchar(128),
    value                          long,
    creation_date                  timestamp not null
)
create unique index pk_xb_etc on xbrl.xb_etc
(etc_type, etc_id)

create table xbrl.xb_etc_attributes
(
    etc_type                       tinyint not null,
    etc_id                         bigint not null,
    name                           varchar(128) not null,
    value                          varchar(128) not null,
    creation_date                  timestamp not null
)
create unique index pk_xb_etc_attributes on xbrl.xb_etc_attributes
(etc_type, etc_id, name)
;
create table xbrl.xb_ref
(
    ref_type                       tinyint not null,
    ref_id                         bigint not null,
    ref_name                       varchar(128) not null,
    creation_date                  timestamp not null
)
create unique index pk_xb_ref on xbrl.xb_ref
(ref_type, ref_id)

create table xbrl.xb_ref_attributes
(
    ref_type                       tinyint not null,
    ref_id                         bigint not null,
    name                           varchar(128) not null,
    value                          varchar(512) not null,
    creation_date                  timestamp not null
)
create unique index pk_xb_ref_attributes on xbrl.xb_ref_attributes
(ref_type, ref_id, name)
;
create table xbrl.xb_mapping
(
    taxonomy_group_id              bigint not null,
    taxonomy_item_id               bigint not null,
    user_item_id                   bigint not null,
    item_precision                 int,
    item_decimal                   int,
    etc_type                       tinyint,
    etc_id                         bigint,
    tuple_child_flag               tinyint not null,
    description                    varchar(512),
    creation_date                  timestamp not null
)
create unique index pk_xb_mapping on xbrl.xb_mapping
(taxonomy_group_id, taxonomy_item_id)
;
create table xbrl.xb_tuple_data
(
    item_order                     bigint not null,
    taxonomy_group_id              bigint not null,
    taxonomy_item_id               bigint not null,
    taxonomy_item_seq              bigint not null,
    parent_taxonomy_item_id        bigint not null,
    parent_taxonomy_item_seq       bigint not null,
    item_value                     varchar(512),
    context_id                     bigint not null
)
;
create table xbrl.xb_item_footnote
(
    main_id                        bigint not null,
    etc_type                       tinyint not null,
    etc_id                         bigint not null,
    parent_etc_id                  bigint not null,
    presentation_order             bigint,
    creation_date                  timestamp not null
)
create unique index pk_xb_item_footnote on xbrl.xb_item_footnote
(main_id, etc_type, etc_id, parent_etc_id)
;