/**
 *  IR Programs Library
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __IRPrograms_HPP
#define __IRPrograms_HPP

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <vector>
#include <string>
#include <map>
#include <new>
#include <wchar.h>

#include <audioeffectx.h>

#include <expat.h>

#define BUFSIZE 1024  

// example
// <?xml version="1.0" encoding="UTF-8"?>
// <fv3:programs>
// <fv3:ir fv3:msb="0" fv3:lsb="0" fv3:prg="0"
// file="C:\Test1.wav"/>
// </fv3:programs>
// map ... [msb|lsb|prg] 0x00|00|00

#define FV3_XML_IR_ELEMENT "/fv3:programs/fv3:ir"
#define FV3_XML_IR_MSB "fv3:msb"
#define FV3_XML_IR_LSB "fv3:lsb"
#define FV3_XML_IR_PRG "fv3:prg"
#define FV3_XML_IR_FILE "fv3:file"

typedef struct {
  std::map<VstInt32,std::string> * IRPMap;
  std::string * tree;
} ParserData;

class IRPrograms
{
public:
  IRPrograms();
  virtual ~IRPrograms();
  int registerFromXML(const char * xmlfile);
  void unregister();
  const char * getFilenameA(VstInt32 msb, VstInt32 lsb, VstInt32 prg);
private:
  std::map<VstInt32,std::string> IRPMap;
  std::string tree;
  ParserData pData;
  char blank[1];
};

#endif
