/**
 *  General GUI
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GeneralEditor_H
#define __GeneralEditor_H

#include <aeffguieditor.h>
#include <vstgui.h>
#include "vstguiev.hpp"
#include <vstcontrols.h>
#include <cfileselector.h>
#include <audioeffectx.h>
#include "ProcessBlock.hpp"
#include "X1_Limiter.hpp"

#define kBackBitmap        "g_back.bmp"
#define kVSliderBitmap     "g_knob.bmp"
#define kVSliderBackBitmap "g_knobback.bmp"
#define kX1LBackBitmap     "x1limiter.bmp"
#define kX1KnobBitmap1     "durks-medium.bmp"
#define kX1OnOffBitmap1    "o_button.bmp"

#define kKnobs 8

enum {
  kVuMeterX = 220, kVuMeterY = 220, kVuMeterOffsetX1 = 190, kVuMeterOffsetX2 = 190+215, kVuMeterOffsetY = 40,
  kVuMeterCX = 108, kVuMeterCY = 169,
  kVuMeterN1 = 21, kVuMeterN2 = 98, kVuMeterN3 = 118, kVuMeterD1 = 45, kVuMeterD2 = 135,
};

typedef float (*PARAMCONV)(int, float);

class X1LimiterEditor :
  public AEffGUIEditor, CControlListener
{
public:
  X1LimiterEditor(AudioEffectX *effect) ALIGN_ARG_POINTER;
  virtual ~X1LimiterEditor() ALIGN_ARG_POINTER;
  virtual bool open(void *ptr) ALIGN_ARG_POINTER;
  virtual void close() ALIGN_ARG_POINTER;
  virtual void idle() ALIGN_ARG_POINTER;
  virtual void setParameter(VstInt32 index, float value) ALIGN_ARG_POINTER;
  virtual void valueChanged(CControl * pControl) ALIGN_ARG_POINTER;

  void setVuMeter(float t, float v, float s, float u);
  float limitFader(float value);
  void registerParamConverter(PARAMCONV def);

private:
  AudioEffectX *aeffect;
  CNeedleMeter *vuMeterL, *vuMeterR;
  CAnimKnob * animKnob[kKnobs];
  CTextEdit * textEdit[kKnobs];
  COnOffButton *stLinkB;
  float cgainL, cgavuL, cgainR, cgavuR;
  PARAMCONV paramConv;
};

#endif
