/**
 *  Slot Locker
 *
 *  Copyright (C) 2006-2017 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "Locker.hpp"

Locker::Locker()
{
#ifdef WIN32
  hMutex = CreateMutex(NULL, FALSE, NULL);
#else
  pthread_mutex_init(&mutex, NULL);
#endif
}

Locker::~Locker()
{
#ifdef WIN32
  CloseHandle(hMutex);
#else
  pthread_mutex_destroy(&mutex);
#endif
}

void Locker::lock()
{
#ifdef WIN32
  WaitForSingleObject(hMutex, INFINITE);
#else
  pthread_mutex_lock(&mutex);
#endif
}

void Locker::unlock()
{
#ifdef WIN32
  ReleaseMutex(hMutex);
#else
  pthread_mutex_unlock(&mutex);
#endif
}

bool Locker::tryLock()
{
#ifdef WIN32
  DWORD checkMutex = WaitForSingleObject(hMutex, 0);
  if(checkMutex == WAIT_OBJECT_0) return true;
  else return false;
#else
  if(pthread_mutex_trylock(&mutex) == 0) return true;
  else return false;
#endif
}
