; Setup Script for MinGW-w64 runtime dll files

#define MinGW_w64Ver "1.0"
#define GCCVer "4.5.3"
[Setup]
AppName=MinGW-w64 runtime
AppVersion={#MinGW_w64Ver}-{#GCCVer}
DefaultDirName={pf}\MinGW-w64
DefaultGroupName=MinGW-w64 runtime
;UninstallDisplayIcon={app}\MyProg.exe
Compression=lzma2
SolidCompression=yes
OutputDir=SetupOutput
OutputBaseFilename=SetupMinGWRuntime-{#MinGW_w64Ver}-{#GCCVer}
; "ArchitecturesInstallIn64BitMode=x64" requests that the install be
; done in "64-bit mode" on x64, meaning it should use the native
; 64-bit Program Files directory and the 64-bit view of the registry.
; On all other architectures it will install in "32-bit mode".
ArchitecturesInstallIn64BitMode=x64
; Note: We don't set ProcessorsAllowed because we want this
; installation to run on all architectures (including Itanium,
; since it's capable of running 32-bit code too).

[Files]
; Install 64bit dll if running in 64-bit mode (x64; see above),
Source: "32\mingwm10.dll";        DestDir: "{sys}"; Check: not Is64BitInstallMode
Source: "32\libgcc_s_sjlj-1.dll"; DestDir: "{sys}"; Check: not Is64BitInstallMode
Source: "32\libstdc++-6.dll";     DestDir: "{sys}"; Check: not Is64BitInstallMode
Source: "32\libgfortran-3.dll";   DestDir: "{sys}"; Check: not Is64BitInstallMode
Source: "32\libobjc-2.dll";       DestDir: "{sys}"; Check: not Is64BitInstallMode
Source: "32\libssp-0.dll";        DestDir: "{sys}"; Check: not Is64BitInstallMode

Source: "32\mingwm10.dll";        DestDir: "{syswow64}"; Check: Is64BitInstallMode
Source: "32\libgcc_s_sjlj-1.dll"; DestDir: "{syswow64}"; Check: Is64BitInstallMode
Source: "32\libstdc++-6.dll";     DestDir: "{syswow64}"; Check: Is64BitInstallMode
Source: "32\libgfortran-3.dll";   DestDir: "{syswow64}"; Check: Is64BitInstallMode
Source: "32\libobjc-2.dll";       DestDir: "{syswow64}"; Check: Is64BitInstallMode
Source: "32\libssp-0.dll";        DestDir: "{syswow64}"; Check: Is64BitInstallMode

Source: "64\libgcc_s_sjlj-1.dll"; DestDir: "{sys}"; Check: Is64BitInstallMode
Source: "64\libstdc++-6.dll";     DestDir: "{sys}"; Check: Is64BitInstallMode
Source: "64\libgfortran-3.dll";   DestDir: "{sys}"; Check: Is64BitInstallMode
Source: "64\libobjc-2.dll";       DestDir: "{sys}"; Check: Is64BitInstallMode
Source: "64\libssp-0.dll";        DestDir: "{sys}"; Check: Is64BitInstallMode

;[Icons]
;Name: "{group}\MinGW-w64"; Filename: "{app}\MyProg.exe"
