#!/bin/bash

# PPC 10.4u
# P64 10.4u
# X86 10.4u
# X64 10.5

export set PATH=/opt/mac/x64/bin:$PATH
export set target=x86_64-apple-darwin9
export set host=$target
export set build=i486-linux-gnu
export set CFLAGS="-pipe -Wall -O3 -ffast-math -march=nocona -mfpmath=sse -mmacosx-version-min=10.5"
export set CFLAGS="$CFLAGS -I /opt/mac/x64/lib/gcc/x86_64-apple-darwin9/4.0.1/include"
export set CXXFLAGS="$CFLAGS -I /opt/mac/x64/include/c++/4.0.1 -I /opt/mac/x64/include/c++/4.0.1/x86_64-apple-darwin9"
export set OBJCFLAGS=$CFLAGS
export set OBJCXXFLAGS=$CFLAGS

./configure \
--prefix=/Freeverb3_VST --build=$build --host=$host --target=$target --enable-vsttarget=macosx \
--disable-static --enable-shared --disable-debug --disable-undenormal --enable-cocoa \
--enable-dstr=-macosx-fast-singleprecision --enable-macarchstr=x86_64 --enable-fftw3n=fftw3f

if [ "$1" = "make" ];then
  make clean ; make -j4
fi

export set PATH=/opt/mac/p64/bin:$PATH
export set target=powerpc64-apple-darwin9
export set host=$target
export set build=i486-linux-gnu
export set CFLAGS="-pipe -Wall -ffast-math -mcpu=G5 -O2 -pipe -maltivec -mabi=altivec -isysroot /opt/mac/SDKs/MacOSX10.5.sdk -mmacosx-version-min=10.5"
export set CFLAGS="$CFLAGS -I /opt/mac/p64/lib/gcc/powerpc64-apple-darwin9/4.0.1/include"
export set CXXFLAGS="$CFLAGS  -I /opt/mac/p64/include/c++/4.0.1 -I /opt/mac/p64/include/c++/4.0.1/powerpc64-apple-darwin9"
export set OBJCFLAGS=$CFLAGS
export set OBJCXXFLAGS=$CFLAGS

./configure \
--prefix=/Freeverb3_VST --build=$build --host=$host --target=$target --enable-vsttarget=macosx \
--disable-static --enable-shared --disable-debug --disable-undenormal --enable-cocoa \
--enable-dstr=-macosx-fast-singleprecision --enable-macarchstr=ppc64 --enable-fftw3n=fftw3f

if [ "$1" = "make" ];then
  make clean ;  make -j4
fi

export set PATH=/opt/mac/bin:$PATH
export set target=powerpc-apple-darwin8
export set host=$target
export set build=i486-linux-gnu
export set CFLAGS="-pipe -Wall -ffast-math -mcpu=7400 -O2 -pipe -maltivec -mabi=altivec"
export set CFLAGS="$CFLAGS -I /opt/mac/lib/gcc/powerpc-apple-darwin8/4.0.1/include"
export set CXXFLAGS=$CFLAGS
export set OBJCFLAGS=$CFLAGS
export set OBJCXXFLAGS=$CFLAGS

./configure \
--prefix=/Freeverb3_VST --build=$build --host=$host --target=$target --enable-vsttarget=macosx \
--disable-static --enable-shared --disable-debug --disable-undenormal \
--enable-dstr=-macosx-fast-singleprecision --enable-macarchstr=ppc --enable-fftw3n=fftw3f

if [ "$1" = "make" ];then
  make clean ;  make -j4
fi

export set PATH=/opt/mac/bin:$PATH
export set target=i686-apple-darwin8
export set host=$target
export set build=i486-linux-gnu
export set CFLAGS="-pipe -Wall -O3 -ffast-math -DENABLE_SSE3 -march=prescott -mfpmath=sse"
export set CFLAGS="$CFLAGS -I /opt/mac/lib/gcc/i686-apple-darwin8/4.0.1/include"
export set CXXFLAGS=$CFLAGS
export set OBJCFLAGS=$CFLAGS
export set OBJCXXFLAGS=$CFLAGS

./configure \
--prefix=/Freeverb3_VST --build=$build --host=$host --target=$target --enable-vsttarget=macosx \
--disable-static --enable-shared --disable-debug --disable-undenormal \
--enable-dstr=-macosx-fast-singleprecision --enable-macarchstr=x86 --enable-fftw3n=fftw3f

if [ "$1" = "make" ];then
  make clean ; make -j4
fi
