#!/bin/bash

# Build external libraries

MAKE="make -j2"
EXPAT_SRC=expat-2.0.1.tar.gz
EXPAT_DIR=expat-2.0.1

if [ ! -f "$EXPAT_SRC" ]; then
    echo "$EXPAT_SRC" not found.
    exit -1
fi

tar -zxvf "$EXPAT_SRC"

source cross-set.sh

# Delete directory entory in the libdir='' section to inhibit MinGW linking errors.
# sed -i -e "s/libdir='.*'/libdir=''/g" *.la

# 32bit

PATH=$PATH:/opt/MinGW/bin
target=i686-w64-mingw32
host=x86_64-linux-gnu
set_cmd
export CFLAGS="$SPFLAGS -Wall -O3"
export CXXFLAGS=$CFLAGS
(cd "$EXPAT_DIR"; make distclean; ./configure --prefix=/opt/MinGW --host=$host --target=$target --disable-debug --enable-static --disable-shared; $MAKE; \
cp .libs/libexpat.a ../libexpat.a)

# 64bit

PATH=$PATH:/usr/opt/MinGW-W64/bin
target=x86_64-w64-mingw32
host=x86_64-linux-gnu
set_cmd
export CFLAGS="$SPFLAGS -Wall -O3"
export CXXFLAGS=$CFLAGS
(cd "$EXPAT_DIR"; make distclean; ./configure --prefix=/opt/MinGW-W64 --host=$host --target=$target --disable-debug --enable-static --disable-shared; $MAKE; \
cp .libs/libexpat.a ../libexpat-x64.a)

# Mac

PATH=$PATH:/opt/mac/x64/bin
target=x86_64-apple-darwin9
host=x86_64-linux-gnu
set_cmd_mac64
export CFLAGS="-O3 -Wall"
export CXXFLAGS="$CFLAGS"
(cd "$EXPAT_DIR"; make distclean; ./configure --prefix=/opt/mac/x64 --host=$host --target=$target --disable-debug --enable-static --disable-shared; $MAKE; \
cp .libs/libexpat.a ../libexpat-mac-x64.a)

PATH=$PATH:/opt/mac/p64/bin
target=powerpc64-apple-darwin9
host=x86_64-linux-gnu
set_cmd_mac64
export CFLAGS="-O3 -Wall"
export CXXFLAGS="$CFLAGS"
(cd "$EXPAT_DIR"; make distclean; ./configure --prefix=/opt/mac/p64 --host=$host --target=$target --disable-debug --enable-static --disable-shared; $MAKE; \
cp .libs/libexpat.a ../libexpat-mac-ppc64.a)

PATH=$PATH:/opt/mac/bin
target=i686-apple-darwin8
host=x86_64-linux-gnu
set_cmd_mac
export LDFLAGS="-arch i386 -arch ppc"
export CFLAGS="-O3 -Wall -arch i386 -arch ppc"
export CXXFLAGS="$CFLAGS"
(cd "$EXPAT_DIR"; make distclean; ./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared; $MAKE; \
cp .libs/libexpat.a ../libexpat-mac-32.a)

i686-apple-darwin8-lipo -create libexpat-mac-32.a libexpat-mac-x64.a libexpat-mac-ppc64.a -output libexpat-mac.a
