#!/bin/bash

source cross-set.sh

# Build ogg/vorbis/flac libraries

MAKE="make -j2"

OGG_SRC=libogg-1.3.2.tar.xz
OGG_DIR=libogg-1.3.2
VOR_SRC=libvorbis-1.3.5.tar.xz
VOR_DIR=libvorbis-1.3.5
FLA_SRC=flac-1.3.1.tar.xz
FLA_DIR=flac-1.3.1

if [ ! -f "$OGG_SRC" ]; then
  echo "$OGG_SRC" not found.
  exit -1
fi

tar -xvf "$OGG_SRC"

if [ ! -f "$VOR_SRC" ]; then
  echo "$VOR_SRC" not found.
  exit -1
fi

tar -xvf "$VOR_SRC"

if [ ! -f "$FLA_SRC" ]; then
  echo "$FLA_SRC" not found.
  exit -1
fi

tar -xvf "$FLA_SRC"

cp -r "$OGG_DIR/include/ogg/" "$VOR_DIR/include/"
cp -r "$OGG_DIR/include/ogg/" "$FLA_DIR/include/"
cp -r "$VOR_DIR/include/vorbis/" "$FLA_DIR/include/"

# Win 32bit

PATH=$PATH:/opt/MinGW/bin
target=i686-w64-mingw32
# host=x86_64-linux-gnu configure.ac bug
host=i686-w64-mingw32
set_cmd
export CFLAGS="$SPFLAGS -pipe -Wall -O3 -ffast-math -march=pentium3 -mfpmath=sse"
export CXXFLAGS=$CFLAGS

(cd "$OGG_DIR"; make distclean; \
 ./configure --prefix=/opt/MinGW --host=$host --target=$target --disable-debug --enable-static --disable-shared; \
 $MAKE -C src; cp src/.libs/libogg.a ../libogg.a)

(cd "$VOR_DIR"; make distclean; \
 ./configure --prefix=/opt/MinGW --host=$host --target=$target --disable-oggtest --disable-debug --enable-static --disable-shared; \
 $MAKE -C lib; cp lib/.libs/libvorbis.a ../libvorbis.a; \
 cp lib/.libs/libvorbisenc.a ../libvorbisenc.a; \
 cp lib/.libs/libvorbisfile.a ../libvorbisfile.a)

(cd "$FLA_DIR"; make distclean; \
./configure --prefix=/opt/MinGW --host=$host --target=$target \
--disable-debug --enable-static --disable-shared --disable-asm-optimizations; \
$MAKE -C src/share; $MAKE -C src/libFLAC; cp src/libFLAC/.libs/libFLAC.a ../libFLAC.a)

# Win 64bit

PATH=$PATH:/usr/opt/MinGW-W64/bin
target=x86_64-w64-mingw32
# host=x86_64-linux-gnu configure.ac bug
host=i686-w64-mingw32
set_cmd
export CFLAGS="$SPFLAGS -pipe -Wall -O3 -ffast-math -mfpmath=sse -msse -msse2"
export CXXFLAGS=$CFLAGS
(cd "$OGG_DIR"; make distclean; \
 ./configure --prefix=/opt/MinGW-W64 --host=$host --target=$target --disable-debug --enable-static --disable-shared; \
 $MAKE -C src; cp src/.libs/libogg.a ../libogg-x64.a)

(cd "$VOR_DIR"; make distclean; \
 ./configure --prefix=/opt/MinGW-W64 --host=$host --target=$target --disable-oggtest --disable-debug --enable-static --disable-shared; \
 $MAKE -C lib; cp lib/.libs/libvorbis.a ../libvorbis-x64.a; \
 cp lib/.libs/libvorbisenc.a ../libvorbisenc-x64.a; \
 cp lib/.libs/libvorbisfile.a ../libvorbisfile-x64.a)

(cd "$FLA_DIR"; make distclean; \
 ./configure --prefix=/opt/MinGW-W64 --host=$host --target=$target --disable-debug --enable-static --disable-shared --disable-asm-optimizations; \
 $MAKE -C src/share; $MAKE -C src/libFLAC; cp src/libFLAC/.libs/libFLAC.a ../libFLAC-x64.a)

# Mac x64/ppc64

PATH=$PATH:/opt/mac/x64/bin:/opt/mac/p64/bin

target=x86_64-apple-darwin9
host=x86_64-linux-gnu
set_cmd_mac64
export CFLAGS="-pipe -Wall -O3 -ffast-math -march=nocona -mfpmath=sse -I /opt/mac/x64/lib/gcc/x86_64-apple-darwin9/4.0.1/include"
export CXXFLAGS=$CFLAGS
(cd "$OGG_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared; \
$MAKE -C src; cp src/.libs/libogg.a ../libogg-mac-x64.a)
(cd "$VOR_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-oggtest --disable-debug --enable-static --disable-shared; \
$MAKE -C lib; cp lib/.libs/libvorbis.a ../libvorbis-mac-x64.a; \
cp lib/.libs/libvorbisenc.a ../libvorbisenc-mac-x64.a; \
cp lib/.libs/libvorbisfile.a ../libvorbisfile-mac-x64.a)
(cd "$FLA_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared --disable-asm-optimizations; \
$MAKE -C src/libFLAC; cp src/libFLAC/.libs/libFLAC.a ../libFLAC-mac-x64.a)

target=powerpc64-apple-darwin9
host=x86_64-linux-gnu
set_cmd_mac64
export CFLAGS="-pipe -Wall -ffast-math -mcpu=G5 -O2 -pipe -maltivec -mabi=altivec"
export CXXFLAGS=$CFLAGS
(cd "$OGG_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared; \
$MAKE -C src; cp src/.libs/libogg.a ../libogg-mac-ppc64.a)
(cd "$VOR_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-oggtest --disable-debug --enable-static --disable-shared; \
$MAKE -C lib; cp lib/.libs/libvorbis.a ../libvorbis-mac-ppc64.a; \
cp lib/.libs/libvorbisenc.a ../libvorbisenc-mac-ppc64.a; \
cp lib/.libs/libvorbisfile.a ../libvorbisfile-mac-ppc64.a)
(cd "$FLA_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared --disable-asm-optimizations; \
$MAKE -C src/libFLAC; cp src/libFLAC/.libs/libFLAC.a ../libFLAC-mac-ppc64.a)

# Mac x86/ppc

PATH=$PATH:/opt/mac/bin

target=powerpc-apple-darwin8
host=x86_64-linux-gnu
set_cmd_mac
export CFLAGS="-pipe -Wall -ffast-math -mcpu=7400 -O2 -pipe -maltivec -mabi=altivec"
export CXXFLAGS=$CFLAGS
(cd "$OGG_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared; \
$MAKE -C src; cp src/.libs/libogg.a ../libogg-mac-ppc.a)
(cd "$VOR_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-oggtest --disable-debug --enable-static --disable-shared; \
$MAKE -C lib; cp lib/.libs/libvorbis.a ../libvorbis-mac-ppc.a; \
cp lib/.libs/libvorbisenc.a ../libvorbisenc-mac-ppc.a; \
cp lib/.libs/libvorbisfile.a ../libvorbisfile-mac-ppc.a)
(cd "$FLA_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared --disable-asm-optimizations; \
$MAKE -C src/libFLAC; cp src/libFLAC/.libs/libFLAC.a ../libFLAC-mac-ppc.a)

target=i686-apple-darwin8
host=x86_64-linux-gnu
set_cmd_mac
export CFLAGS="-pipe -Wall -O3 -ffast-math -march=prescott -mfpmath=sse"
export CXXFLAGS=$CFLAGS
(cd "$OGG_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared; \
$MAKE -C src; cp src/.libs/libogg.a ../libogg-mac-x86.a)
(cd "$VOR_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-oggtest --disable-debug --enable-static --disable-shared; \
$MAKE -C lib; cp lib/.libs/libvorbis.a ../libvorbis-mac-x86.a; \
cp lib/.libs/libvorbisenc.a ../libvorbisenc-mac-x86.a; \
cp lib/.libs/libvorbisfile.a ../libvorbisfile-mac-x86.a)
(cd "$FLA_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-static --disable-shared --disable-asm-optimizations; \
$MAKE -C src/libFLAC; cp src/libFLAC/.libs/libFLAC.a ../libFLAC-mac-x86.a)

i686-apple-darwin8-lipo -create libogg-mac-x86.a libogg-mac-ppc.a libogg-mac-x64.a libogg-mac-ppc64.a -output libogg-mac.a
i686-apple-darwin8-lipo -create libvorbis-mac-x86.a libvorbis-mac-ppc.a libvorbis-mac-x64.a libvorbis-mac-ppc64.a -output libvorbis-mac.a
i686-apple-darwin8-lipo -create libvorbisenc-mac-x86.a libvorbisenc-mac-ppc.a libvorbisenc-mac-x64.a libvorbisenc-mac-ppc64.a -output libvorbisenc-mac.a
i686-apple-darwin8-lipo -create libvorbisfile-mac-x86.a libvorbisfile-mac-ppc.a libvorbisfile-mac-x64.a libvorbisfile-mac-ppc64.a -output libvorbisfile-mac.a
i686-apple-darwin8-lipo -create libFLAC-mac-x86.a libFLAC-mac-ppc.a libFLAC-mac-x64.a libFLAC-mac-ppc64.a -output libFLAC-mac.a
