#!/bin/bash

# Build FFTW libraries

source cross-set.sh

MAKE="make -j4"

FFTW3_SRC=fftw-3.3.6-pl2.tar.gz
FFTW3_DIR=fftw-3.3.6-pl2

if [ ! -f "$FFTW3_SRC" ]; then
  echo "$FFTW3_SRC" not found.
  exit -1
fi

tar -zxvf "$FFTW3_SRC"

# Mac

# AMD64
PATH=/opt/mac/x64/bin:$PATH
target=x86_64-apple-darwin9
host=x86_64-linux-gnu
set_cmd_mac64
export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=nocona -mfpmath=sse -I /opt/mac/x64/lib/gcc/x86_64-apple-darwin9/4.0.1/include"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/mac/x64 --host=$host --target=$target --disable-debug --with-our-malloc --enable-sse --enable-single --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3f.a  ../libfftw3f-mac-x64.a)

# PPC64
PATH=/opt/mac/p64/bin:$PATH
target=powerpc64-apple-darwin9
host=x86_64-linux-gnu
set_cmd_mac64
export CFLAGS="$SPFLAGS -Wall -O2 -ffast-math -I /opt/mac/p64/lib/gcc/powerpc64-apple-darwin9/4.0.1/include"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/mac/p64 --host=$host --target=$target --disable-debug --enable-altivec --enable-single --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3f.a  ../libfftw3f-mac-p64.a)

# PPC
PATH=/opt/mac/bin:$PATH
target=powerpc-apple-darwin8
host=x86_64-linux-gnu
set_cmd_mac
export CFLAGS="$SPFLAGS -Wall -O2 -ffast-math -I /opt/mac/lib/gcc/powerpc-apple-darwin8/4.0.1/include"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --enable-altivec --enable-single --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3f.a  ../libfftw3f-mac-ppc.a)

# X86
PATH=/opt/mac/bin:$PATH
target=i686-apple-darwin8
host=x86_64-linux-gnu
set_cmd_mac
export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=prescott -mfpmath=sse -I /opt/mac/lib/gcc/i686-apple-darwin8/4.0.1/include"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/mac --host=$host --target=$target --disable-debug --with-our-malloc --enable-sse --enable-single --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3f.a  ../libfftw3f-mac-x86.a)

i686-apple-darwin8-lipo -create libfftw3f-mac-x86.a libfftw3f-mac-ppc.a libfftw3f-mac-x64.a libfftw3f-mac-ppc64.a -output libfftw3f-mac.a

# ==== Windows 32bit ====

PATH=/opt/MinGW-w32/bin:$PATH
target=i686-w64-mingw32
host=x86_64-linux-gnu
set_cmd

# single X87
#export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math"
#export CXXFLAGS=$CFLAGS
#(cd "$FFTW3_DIR"; make distclean; \
#./configure --prefix=/opt/MinGW-w32 --host=$host --target=$target \
#--disable-debug --enable-single --enable-static --disable-shared; \
#$MAKE; cp .libs/libfftw3f.a ../libfftw3f.a)

# single SSE
export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=pentium3 -mfpmath=sse -msse -mstackrealign"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/MinGW-w32 --host=$host --target=$target --disable-debug \
--with-our-malloc --enable-sse --enable-single --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3f.a  ../libfftw3f-sse.a)

# single AVX
export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=corei7-avx -mfpmath=sse -mstackrealign"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/MinGW-w32 --host=$host --target=$target --disable-debug \
--with-our-malloc --enable-avx --enable-single --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3f.a  ../libfftw3f-avx.a)

# single 3DNow! ... fftw3-3.1.2 only.
# The following replacement is for Windows Underscore Symbols
# cd dft/k7/codelets/
# for s in *.S; do sed -i s/fftwf_/_fftwf_/g $s; done

#FFTW3L_SRC=fftw-3.1.2.tar.gz
#FFTW3L_DIR=fftw-3.1.2

#if [ ! -f "$FFTW3L_SRC" ]; then
#  echo SRCL not found.
#  exit -1
#fi

#tar -zxvf "$FFTW3L_SRC"

#export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=athlon -m3dnow"
#export CXXFLAGS=$CFLAGS
#(cd "$FFTW3L_DIR"; make distclean; \
#sed -i s/fftwf_/_fftwf_/g dft/k7/codelets/*.S; \
#./configure --prefix=/opt/MinGW-w32 --host=$host --target=$target --disable-debug \
#--enable-k7 --enable-single --enable-static --disable-shared; \
#$MAKE; cp .libs/libfftw3f.a ../libfftw3f-3dnow.a)

# double X87
#export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math"
#export CXXFLAGS=$CFLAGS
#(cd "$FFTW3_DIR"; make distclean; \
#./configure --prefix=/opt/MinGW-w32 --host=$host --target=$target --disable-debug --enable-static; \
#$MAKE; cp .libs/libfftw3.a  ../libfftw3.a)

# double SSE2
export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=pentium4 -mfpmath=sse -mstackrealign"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/MinGW-w32 --host=$host --target=$target --disable-debug \
--with-our-malloc --enable-sse2 --enable-double --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3.a  ../libfftw3-sse2.a)

# double AVX
export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=corei7-avx -mfpmath=sse -mstackrealign"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/MinGW-w32 --host=$host --target=$target --disable-debug \
--with-our-malloc --enable-avx --enable-double --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3.a  ../libfftw3-avx.a)

# ==== Windows 64bit ====

PATH=/opt/MinGW-w64/bin:$PATH
target=x86_64-w64-mingw32
host=i686-gentoo-linux
set_cmd

# single SSE
export CFLAGS="$SPFLAGS -Wall -O2 -ffast-math -mfpmath=sse -msse -msse2"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/MinGW-w64 --host=$host --target=$target --disable-debug \
--with-our-malloc --enable-sse --enable-single --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3f.a  ../libfftw3f-x64.a)

# single AVX
export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=corei7-avx -mfpmath=sse -mstackrealign"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/MinGW-w64 --host=$host --target=$target --disable-debug \
--with-our-malloc --enable-avx --enable-single --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3f.a  ../libfftw3f-x64-avx.a)

# double SSE
export CFLAGS="$SPFLAGS -Wall -O2 -ffast-math -mfpmath=sse -msse -msse2"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/MinGW-w64 --host=$host --target=$target --disable-debug \
--with-our-malloc --enable-sse2 --enable-double --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3.a  ../libfftw3-x64.a)

# double AVX
export CFLAGS="$SPFLAGS -Wall -O3 -ffast-math -march=corei7-avx -mfpmath=sse -mstackrealign"
export CXXFLAGS=$CFLAGS
(cd "$FFTW3_DIR"; make distclean; \
./configure --prefix=/opt/MinGW-w64 --host=$host --target=$target --disable-debug \
--with-our-malloc --enable-avx --enable-double --enable-static --disable-shared; \
$MAKE; cp .libs/libfftw3.a  ../libfftw3-x64-avx.a)

exit 0
