/**
 *  Mac dependent codes
 *
 *  Copyright (C) 2006-2014 Teru Kamogashira
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <Cocoa/Cocoa.h>

#import "Mac.h"

#ifdef MAC
void MacMessageBox(char * title, char * string)
{
  NSString * info = [[NSString alloc] initWithFormat:@"%s", title];
  NSString * text = [[NSString alloc] initWithFormat:@"%s", string];
  NSAlert* alert =[NSAlert alertWithMessageText:text
		   defaultButton:@"OK" alternateButton:nil otherButton:nil
		   informativeTextWithFormat:info];
  [alert runModal];
}

void getHomeDirectoryName(char * str)
{
  char path[PATH_MAX];
  CFStringGetCString((CFStringRef)NSHomeDirectory(), path, sizeof(path), kCFStringEncodingUTF8);
  memcpy(str, path, PATH_MAX);
}
#endif
